# ESP32 Peripheral Manager API Documentation

This package contains comprehensive documentation for the ESP32 Peripheral Manager (PerimaN) API.

## Files Included:

- `esp32-hal-periman-api.md` - Complete API documentation in Markdown format
- `esp32-hal-periman-api.rst` - Complete API documentation in reStructuredText format
- `examples.c` - Code examples and usage patterns
- `esp32-hal-periman.h` - Header file with function declarations
- `README.md` - This file

## Quick Start:

1. Include the header: `#include "esp32-hal-periman.h"`
2. Register deinit callbacks before using peripherals
3. Clear pins before assignment: `perimanClearPinBus(pin)`
4. Assign pins: `perimanSetPinBus(pin, type, bus, num, channel)`
5. Always check return values for error handling

## Key Functions:

- `perimanSetPinBus()` - Assign pin to peripheral
- `perimanClearPinBus()` - Release pin assignment  
- `perimanGetPinBus()` - Get bus handle for pin
- `perimanGetPinBusType()` - Get current pin assignment
- `perimanSetBusDeinit()` - Register cleanup callback

## Supported Peripheral Types:

- GPIO, UART (RX/TX/CTS/RTS)
- I2C (Master SDA/SCL)
- LEDC (PWM), RMT (TX/RX)
- Sigma-Delta, ADC (OneShot/Continuous)
- Touch sensors, and more

## Documentation Formats:

- **Markdown (.md)**: Perfect for GitHub, GitLab, and general documentation
- **reStructuredText (.rst)**: Ideal for Sphinx documentation and Python ecosystems

## Example Usage:

```c
#include "esp32-hal-periman.h"

// Register cleanup callback
perimanSetBusDeinit(ESP32_BUS_TYPE_I2C_MASTER_SDA, i2c_deinit_callback);

// Clear pin if previously assigned
if (!perimanClearPinBus(21)) {
    log_e("Failed to clear pin 21");
}

// Assign pin to I2C SDA
if (!perimanSetPinBus(21, ESP32_BUS_TYPE_I2C_MASTER_SDA, (void*)1, 0, -1)) {
    log_e("Failed to assign pin 21 to I2C SDA");
}
```

For complete documentation, see the .md or .rst files.

## License

This documentation is based on the ESP32 Arduino Core source code analysis.
Check the original repository for license information.
