from sqlmodel import Session, SQLModel, create_engine, select

from .hero import Hero
from .team import Team


def test_() -> None:
    h1 = Hero(name="me")

    t1 = Team(name="team 1")

    h1.teams.append(t1)

    engine = create_engine("sqlite://")

    SQLModel.metadata.create_all(engine)
    with Session(engine) as session:
        session.add(h1)
        session.add(t1)
        session.commit()

    with Session(engine) as session:
        query_hero = session.scalar(
            select(Hero).limit(1)
        )
        assert query_hero

        assert query_hero.id == 1
        assert query_hero.name == "me"
        assert query_hero.teams[0].name == "team 1"
