import ComposeApp
import Foundation

final class PlatformImpl: Platform {

    private static let formatter: DateFormatter = {
        let formatter = DateFormatter()
        formatter.dateFormat = "yyyy-MM-dd HH:mm:ss.SSS"
        return formatter
    }()

    func log(tag: String, message: String) {
        let date = Self.formatter.string(from: Date())
        print("\(date) \(tag): \(message)")
    }
}
