package org.example.project

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.currentCoroutineContext
import kotlinx.coroutines.delay
import kotlinx.coroutines.flow.MutableSharedFlow
import kotlinx.coroutines.launch

class AppViewModel : ViewModel() {

    companion object {
        private val TAG = "AppViewModel"
    }

    private val sharedFlow = MutableSharedFlow<String>(replay = 1).apply {
        tryEmit("first")
    }

    init {
        viewModelScope.launch {
            val dispatcher = currentCoroutineContext()[CoroutineDispatcher]
            getPlatform().log(TAG, "Dispatcher is $dispatcher")

            launch {
                sharedFlow.collect {
                    getPlatform().log(TAG, "collected: $it")
                }
            }

            delay(1000)

            getPlatform().log(TAG, "will emit 'second'")
            val secondSuccess = sharedFlow.tryEmit("second")
            getPlatform().log(TAG, "secondSuccess = $secondSuccess")

            getPlatform().log(TAG, "will emit 'third'")
            val thirdSuccess = sharedFlow.tryEmit("third")
            getPlatform().log(TAG, "thirdSuccess = $thirdSuccess")
        }
    }
}