//go:build tailscale

package go_sqlite_bench

import (
	"context"
	"database/sql"
	"database/sql/driver"

	"github.com/tailscale/sqlite"
)

func OpenDB(filename string) (*sql.DB, error) {
	connInitFunc := func(ctx context.Context, conn driver.ConnPrepareContext) error {
		return sqlite.ExecScript(conn.(sqlite.SQLConn), "PRAGMA busy_timeout=10000; PRAGMA foreign_keys=true; PRAGMA journal_mode=WAL; PRAGMA synchronous=normal;")
	}
	return sql.OpenDB(sqlite.Connector("file:"+filename, connInitFunc, nil)), nil
}
