//go:build modernc

package go_sqlite_bench

import (
	"database/sql"

	_ "modernc.org/sqlite"
)

func OpenDB(filename string) (*sql.DB, error) {
	return sql.Open("sqlite", "file:"+filename+"?_pragma=busy_timeout(10000)&_pragma=foreign_keys(true)&_pragma=journal_mode(wal)&_pragma=synchronous(normal)")
}
