import os

import mujoco


def get_asset_dict(asset_dir: str) -> dict[str, bytes]:
    """
    Constructs a dictionary of binary assets from all the files in the specified directory.

    Args:
        asset_dir (str): Path to the directory containing assets.

    Returns:
        dict[str, bytes]: A dictionary where keys are filenames and values are their binary content.
    """
    asset_dict = {}
    for filename in os.listdir(asset_dir):
        file_path = os.path.join(asset_dir, filename)
        if os.path.isfile(file_path):
            with open(file_path, "rb") as f:
                asset_dict[filename] = f.read()
    return asset_dict


# model and assets
model_handle = "test_model.xml"
asset_handle = "meshes"
asset_dict = get_asset_dict(asset_handle)
print(asset_dict.keys())

# spec
spec = mujoco.MjSpec()
spec = spec.from_file(model_handle)
spec.compile(asset_dict)
