local function create_primary_index(space, parts)
    space:create_index('primary', {
        parts = parts,
        if_not_exists = true,
    })
end

local function create_bucket_index(space, sharding_key)
    checks('table', 'table')

    local bucket_field = 'bucket_id'
    space:create_index(bucket_field, {
        parts = { bucket_field },
        unique = false,
        if_not_exists = true,
    })

    local utils = require('migrator.utils')
    utils.register_sharding_key(space.name, sharding_key)
end

local function create_secondary_index(space, name, unique, parts)
    space:create_index(name, {
        parts = parts,
        unique = unique,
        if_not_exists = true,
    })
end

return {
    up = function()
        local log = require('log')

        local space_name = 'space_1'

        log.info('create space: %s', space_name)
        local space = box.schema.space.create(space_name, { if_not_exists = true })

        space:format({
            { name = 'bucket_id', type = 'unsigned', is_nullable = false },
            { name = 'primary', type = 'string', is_nullable = false },
            { name = 'secondary', type = 'string', is_nullable = false },
        })

        create_primary_index(space, { 'primary' })
        create_secondary_index(space, 'secondary', false, { 'secondary' })
        create_bucket_index(space, { 'secondary' })
    end
}
