#!/usr/bin/env tarantool

local net_box = require('net.box')
local fiber = require('fiber')
local clock = require('clock')

--local CONN_STRING = 'localhost:3301' -- SET UP CONECTION STRING TO YOUR ROUTER / PLAIN TARANTOOL
local CONN_STRING = 'admin:secret-cluster-cookie@127.0.0.1:3301' -- SET UP CONECTION STRING TO YOUR ROUTER / PLAIN TARANTOOL
local WORKER_COUNT = 256 -- SET UP NUMBER OF PARALLEL REQUESTS HERE

local conn = assert(net_box.connect(CONN_STRING))

local success_count = 0
local error_count = 0

local secondary_count = 0
local fiber_worker = function()
    while true do
        secondary_count = secondary_count + 1
        --local _, err = conn:eval("return true") -- YOU CAN SPECIFY ARGUMENTED CALLS HERE
        local _, err = conn:eval("return app.select_space(...)", {'s_test_' .. secondary_count}) -- YOU CAN SPECIFY ARGUMENTED CALLS HERE
--        local secondary = 's_test_' .. secondary_count
--        local _, err = conn:eval([[
--            local secondary = ...
--            local vshard = require('vshard')
--            local bucket_id = vshard.router.bucket_id_mpcrc32(secondary)
--            return crud.select('space_1', {{'==', 'secondary', secondary}}, { bucket_id = bucket_id })
--        ]], { secondary }) -- YOU CAN SPECIFY ARGUMENTED CALLS HERE
        if err ~= nil then error_count = error_count + 1 else success_count = success_count + 1 end
    end
end

local workers = {}

local start_time = clock.monotonic()

for i = 1, WORKER_COUNT do
    workers[i] = fiber.new(fiber_worker, i)
end

while true do
    fiber.sleep(1)
    local report_message = string.format('Success count is %s in %s seconds, average RPS is %s',
        success_count,
        clock.monotonic() - start_time,
        success_count / (clock.monotonic() - start_time)
    )
    print(report_message)
    print('Error count is ' .. error_count)
end

-- STOP IT BY CTRL+C
