local cartridge = require('cartridge')
local vshard = require('vshard')

local function select_space(secondary)
    local bucket_id = vshard.router.bucket_id_mpcrc32(secondary)
    return vshard.router.callro(bucket_id, "box.space.space_1.index.secondary:select", { secondary })
end

local function init(opts) -- luacheck: no unused args
    -- if opts.is_master then
    -- end

    local httpd = assert(cartridge.service_get('httpd'), "Failed to get httpd service")
    httpd:route({method = 'GET', path = '/hello'}, function()
        return {body = 'Hello world!'}
    end)

    local app = {
        select_space = select_space,
    }

    rawset(_G, 'app', app)

    return true
end

local function stop()
    return true
end

local function validate_config(conf_new, conf_old) -- luacheck: no unused args
    return true
end

local function apply_config(conf, opts) -- luacheck: no unused args
    -- if opts.is_master then
    -- end

    return true
end

return {
    role_name = 'app.roles.custom',
    init = init,
    stop = stop,
    validate_config = validate_config,
    apply_config = apply_config,
    -- dependencies = {'cartridge.roles.vshard-router'},
}
