local utils = {}

function utils.merge(...)
    local ret = {}

    for i = 1, select('#', ...) do
        local tbl = select(i, ...)
        assert(type(tbl) == 'table')
        for k, v in pairs(tbl) do
            ret[k] = v
        end
    end

    return ret
end

function utils.map(t, transform)
    local mapped_table = {}
    for k, v in pairs(t) do
        mapped_table[k] = transform(v)
    end
    return mapped_table
end

function utils.reduce(t, cb, start_value)
    local acc = start_value
    for _, v in ipairs(t) do
        acc = cb(acc, v)
    end
    return acc
end

function utils.even(arr, detector)
    for _, value in pairs(arr) do
        if detector(value) then
            return value
        end
    end
    return nil
end

return utils
