# Space explorer

Cartridge WebUI plugin for exploring tarantool spaces and data.

## Usage

- Add it to the rockspec dependencies.
- Add it to the `cartridge.cfg({roles = ...})` list.

## Example

*example-app-scm-1.rockspec*

```lua
package = 'example-app'
version = 'scm-1'
source  = {
    url = '/dev/null',
}
dependencies = {
    'tarantool',
    'lua >= 5.1',
    'luatest == 0.2.0-1',
    'ldecnumber == 1.1.3-1',
    'cartridge == scm-1',
    'space-explorer == scm-1'
}
build = {
    type = 'none';
}
```

*init.lua*
```lua
#!/usr/bin/env tarantool

require('strict').on()

local cartridge = require('cartridge')

local ok, err = cartridge.cfg({
    roles = {
        'cartridge.roles.vshard-storage',
        'cartridge.roles.vshard-router',
        'space-explorer',
        'app.roles.api',
        'app.roles.storage',
    },
})

assert(ok, tostring(err))
```

