package com.example.demo;

import org.springframework.amqp.core.*;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class Queue {
    public static final String QUEUE = "queue.items";
    public static final String DEAD_LETTER_EXCHANGE = "exchange.deadLetter";
    public static final String DEAD_LETTER_QUEUE = "queue.deadLetter";

    @Bean
    public org.springframework.amqp.core.Queue getQueue() {
        return QueueBuilder.durable(QUEUE)
                .deadLetterExchange(DEAD_LETTER_EXCHANGE)
                .build();
    }

    @Bean
    public org.springframework.amqp.core.Queue getDLQueue() {
        return QueueBuilder.durable(DEAD_LETTER_QUEUE)
                .build();
    }

    @Bean
    public FanoutExchange getDLExchange() {
        return ExchangeBuilder.fanoutExchange(DEAD_LETTER_EXCHANGE)
                .durable(true)
                .build();
    }

    @Bean
    public Binding getDLBinding() {
        return BindingBuilder.bind(getDLQueue())
                .to(getDLExchange());
    }
}
