package com.example.demo;

import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.messaging.handler.annotation.Payload;

import static com.example.demo.Queue.QUEUE;

@SpringBootApplication
@Slf4j
public class DemoApplication {

	public static void main(String[] args) {
		SpringApplication.run(DemoApplication.class, args);
	}

	@RabbitListener(queues = QUEUE)
	public void test(@Payload String text) {
		log.info("main method");

		log.info("trying");

		if (text.equals("lalala"))
			throw new RuntimeException("lalala found");

		log.info("done");
	}
}
