/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.values;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import oracle.nosql.driver.util.CheckNull;
import oracle.nosql.driver.util.SizeOf;
import oracle.nosql.driver.values.BinaryValue;
import oracle.nosql.driver.values.BooleanValue;
import oracle.nosql.driver.values.DoubleValue;
import oracle.nosql.driver.values.EmptyValue;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.IntegerValue;
import oracle.nosql.driver.values.JsonOptions;
import oracle.nosql.driver.values.JsonUtils;
import oracle.nosql.driver.values.LongValue;
import oracle.nosql.driver.values.NullValue;
import oracle.nosql.driver.values.NumberValue;
import oracle.nosql.driver.values.StringValue;
import oracle.nosql.driver.values.TimestampValue;

public class MapValue
extends FieldValue {
    private final Map<String, FieldValue> values;
    public static final MapValue EMPTY_VALUE = new MapValue();

    public MapValue() {
        this.values = new HashMap<String, FieldValue>();
    }

    public MapValue(boolean keepInsertionOrder, int size) {
        this.values = keepInsertionOrder ? new LinkedHashMap<String, FieldValue>(size) : new HashMap<String, FieldValue>(size);
    }

    public MapValue(int size) {
        this.values = new HashMap<String, FieldValue>(size);
    }

    @Override
    public FieldValue.Type getType() {
        return FieldValue.Type.MAP;
    }

    public Map<String, FieldValue> getMap() {
        return this.values;
    }

    public Set<Map.Entry<String, FieldValue>> entrySet() {
        return this.values.entrySet();
    }

    public int size() {
        return this.values.size();
    }

    public Collection<FieldValue> values() {
        return this.values.values();
    }

    public MapValue addAll(Iterator<Map.Entry<String, FieldValue>> iter) {
        CheckNull.requireNonNull(iter, "MapValue.addAll: iter must be non-null");
        while (iter.hasNext()) {
            Map.Entry<String, FieldValue> entry = iter.next();
            this.values.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public MapValue addAll(Stream<Map.Entry<String, FieldValue>> stream) {
        CheckNull.requireNonNull(stream, "MapValue.addAll: stream must be non-null");
        stream.forEach(e -> this.values.put((String)e.getKey(), (FieldValue)e.getValue()));
        return this;
    }

    public FieldValue.Type getType(String name) {
        CheckNull.requireNonNull(name, "MapValue.getType: name must be non-null");
        FieldValue val = this.values.get(name);
        return val == null ? null : val.getType();
    }

    public FieldValue get(String name) {
        CheckNull.requireNonNull(name, "MapValue.get: name must be non-null");
        return this.values.get(name);
    }

    public MapValue put(String name, FieldValue value) {
        CheckNull.requireNonNull(name, "MapValue.put: name must be non-null");
        CheckNull.requireNonNull(value, "MapValue.put: value must be non-null");
        MapValue.validateName(name, value);
        this.values.put(name, value);
        return this;
    }

    public MapValue put(String name, int value) {
        return this.put(name, new IntegerValue(value));
    }

    public MapValue put(String name, long value) {
        return this.put(name, new LongValue(value));
    }

    public MapValue put(String name, double value) {
        return this.put(name, new DoubleValue(value));
    }

    public MapValue put(String name, BigDecimal value) {
        return this.put(name, new NumberValue(value));
    }

    public MapValue put(String name, String value) {
        return this.put(name, new StringValue(value));
    }

    public MapValue put(String name, boolean value) {
        return this.put(name, BooleanValue.getInstance(value));
    }

    public MapValue put(String name, byte[] value) {
        return this.put(name, new BinaryValue(value));
    }

    public MapValue put(String name, Timestamp value) {
        return this.put(name, new TimestampValue(value));
    }

    public MapValue putFromJson(String name, String jsonString, JsonOptions options) {
        return this.put(name, JsonUtils.createValueFromJson(jsonString, options));
    }

    public FieldValue remove(String name) {
        return this.values.remove(name);
    }

    public int getInt(String name) {
        FieldValue val = this.values.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Field does not exist: " + name);
        }
        return val.getInt();
    }

    public long getLong(String name) {
        FieldValue val = this.values.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Field does not exist: " + name);
        }
        return val.getLong();
    }

    public double getDouble(String name) {
        FieldValue val = this.values.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Field does not exist: " + name);
        }
        return val.getDouble();
    }

    public BigDecimal getNumber(String name) {
        FieldValue val = this.values.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Field does not exist: " + name);
        }
        return val.getNumber();
    }

    public String getString(String name) {
        FieldValue val = this.values.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Field does not exist: " + name);
        }
        return val.getString();
    }

    public boolean getBoolean(String name) {
        FieldValue val = this.values.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Field does not exist: " + name);
        }
        return val.getBoolean();
    }

    public byte[] getBinary(String name) {
        FieldValue val = this.values.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Field does not exist: " + name);
        }
        return val.getBinary();
    }

    public Timestamp getTimestamp(String name) {
        FieldValue val = this.values.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Field does not exist: " + name);
        }
        return val.getTimestamp();
    }

    @Override
    public int compareTo(FieldValue other) {
        MapValue otherImpl = other.asMap();
        for (String key : this.values.keySet()) {
            FieldValue otherVal = otherImpl.get(key);
            if (otherVal == null) {
                return 1;
            }
            FieldValue val = this.values.get(key);
            try {
                int valCompare = val.compareTo(otherVal);
                if (valCompare == 0) continue;
                return valCompare;
            }
            catch (ClassCastException cce) {
                throw new ClassCastException(cce.getMessage() + ", the key of values: " + key);
            }
        }
        return this.size() < otherImpl.size() ? -1 : 0;
    }

    public boolean equals(Object other) {
        if (other instanceof MapValue) {
            return this.values.equals(((MapValue)other).values);
        }
        return false;
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public long sizeof() {
        long size = SizeOf.OBJECT_OVERHEAD + SizeOf.OBJECT_REF_OVERHEAD + SizeOf.HASHMAP_OVERHEAD;
        for (Map.Entry<String, FieldValue> entry : this.values.entrySet()) {
            size += (long)SizeOf.HASHMAP_ENTRY_OVERHEAD;
            size += (long)SizeOf.stringSize(entry.getKey());
            size += entry.getValue().sizeof();
        }
        return size;
    }

    public void convertEmptyToNull() {
        for (Map.Entry<String, FieldValue> entry : this.values.entrySet()) {
            FieldValue val = entry.getValue();
            if (val != EmptyValue.getInstance()) continue;
            entry.setValue(NullValue.getInstance());
        }
    }
}

