/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.values;

import java.math.BigDecimal;
import java.sql.Timestamp;
import oracle.nosql.driver.util.CheckNull;
import oracle.nosql.driver.util.SizeOf;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.JsonOptions;
import oracle.nosql.driver.values.TimestampValue;

public class LongValue
extends FieldValue {
    private long value;

    public LongValue(long value) {
        this.value = value;
    }

    public LongValue(String value) {
        this.value = Long.parseLong(value);
    }

    @Override
    public FieldValue.Type getType() {
        return FieldValue.Type.LONG;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long v) {
        this.value = v;
    }

    @Override
    public double castAsDouble() {
        return this.value;
    }

    @Override
    public int compareTo(FieldValue other) {
        CheckNull.requireNonNull(other, "LongValue.compareTo: other must be non-null");
        return Long.compare(this.value, other.getLong());
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public BigDecimal getNumber() {
        return new BigDecimal(this.value);
    }

    @Override
    public int getInt() {
        return Math.toIntExact(this.value);
    }

    @Override
    public String getString() {
        return this.toJson(null);
    }

    @Override
    public Timestamp getTimestamp() {
        return new TimestampValue(this.value).getTimestamp();
    }

    @Override
    public String toJson(JsonOptions options) {
        return String.valueOf(this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof LongValue) {
            return this.value == ((LongValue)other).value;
        }
        return false;
    }

    public int hashCode() {
        return Long.valueOf(this.value).hashCode();
    }

    @Override
    public long sizeof() {
        return SizeOf.OBJECT_OVERHEAD + 8;
    }
}

