/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.util;

public final class BinaryProtocol {
    public static final short V1 = 1;
    public static final short QUERY_V1 = 1;
    public static final short V2 = 2;
    public static final short V3 = 3;
    public static final short DEFAULT_SERIAL_VERSION = 3;
    public static final short QUERY_VERSION = 2;
    public static final int ABSOLUTE = 0;
    public static final int EVENTUAL = 1;
    public static final int DURABILITY_SYNC = 1;
    public static final int DURABILITY_NO_SYNC = 2;
    public static final int DURABILITY_WRITE_NO_SYNC = 3;
    public static final int DURABILITY_ALL = 1;
    public static final int DURABILITY_NONE = 2;
    public static final int DURABILITY_SIMPLE_MAJORITY = 3;
    public static final int ACTIVE = 0;
    public static final int CREATING = 1;
    public static final int DROPPED = 2;
    public static final int DROPPING = 3;
    public static final int UPDATING = 4;
    public static final int PROVISIONED = 1;
    public static final int ON_DEMAND = 2;
    public static final int COMPLETE = 0;
    public static final int WORKING = 1;
    public static final int NO_ERROR = 0;
    public static final int USER_ERROR_BEGIN = 1;
    public static final int USER_ERROR_END = 49;
    public static final int THROTTLING_ERROR_BEGIN = 50;
    public static final int THROTTLING_ERROR_END = 99;
    public static final int SERVER_ERROR_BEGIN = 100;
    public static final int SERVER_RETRYABLE_ERROR_BEGIN = 100;
    public static final int SERVER_RETRYABLE_ERROR_END = 124;
    public static final int SERVER_OTHER_ERROR_BEGIN = 125;
    public static final int UNKNOWN_OPERATION = 1;
    public static final int TABLE_NOT_FOUND = 2;
    public static final int INDEX_NOT_FOUND = 3;
    public static final int ILLEGAL_ARGUMENT = 4;
    public static final int ROW_SIZE_LIMIT_EXCEEDED = 5;
    public static final int KEY_SIZE_LIMIT_EXCEEDED = 6;
    public static final int BATCH_OP_NUMBER_LIMIT_EXCEEDED = 7;
    public static final int REQUEST_SIZE_LIMIT_EXCEEDED = 8;
    public static final int TABLE_EXISTS = 9;
    public static final int INDEX_EXISTS = 10;
    public static final int INVALID_AUTHORIZATION = 11;
    public static final int INSUFFICIENT_PERMISSION = 12;
    public static final int RESOURCE_EXISTS = 13;
    public static final int RESOURCE_NOT_FOUND = 14;
    public static final int TABLE_LIMIT_EXCEEDED = 15;
    public static final int INDEX_LIMIT_EXCEEDED = 16;
    public static final int BAD_PROTOCOL_MESSAGE = 17;
    public static final int EVOLUTION_LIMIT_EXCEEDED = 18;
    public static final int TABLE_DEPLOYMENT_LIMIT_EXCEEDED = 19;
    public static final int TENANT_DEPLOYMENT_LIMIT_EXCEEDED = 20;
    public static final int OPERATION_NOT_SUPPORTED = 21;
    public static final int ETAG_MISMATCH = 22;
    public static final int CANNOT_CANCEL_WORK_REQUEST = 23;
    public static final int UNSUPPORTED_PROTOCOL = 24;
    public static final int READ_LIMIT_EXCEEDED = 50;
    public static final int WRITE_LIMIT_EXCEEDED = 51;
    public static final int SIZE_LIMIT_EXCEEDED = 52;
    public static final int OPERATION_LIMIT_EXCEEDED = 53;
    public static final int REQUEST_TIMEOUT = 100;
    public static final int SERVER_ERROR = 101;
    public static final int SERVICE_UNAVAILABLE = 102;
    public static final int SECURITY_INFO_UNAVAILABLE = 104;
    public static final int RETRY_AUTHENTICATION = 105;
    public static final int UNKNOWN_ERROR = 125;
    public static final int ILLEGAL_STATE = 126;
    public static final int TTL_HOURS = 1;
    public static final int TTL_DAYS = 2;
    public static final int ROW_SIZE_LIMIT = 524288;
    public static final int KEY_SIZE_LIMIT = 64;
    public static final int INDEX_KEY_SIZE_LIMIT = 64;
    public static final int BATCH_OP_NUMBER_LIMIT = 50;
    public static final int BATCH_REQUEST_SIZE_LIMIT = 0x1900000;
    public static final int REQUEST_SIZE_LIMIT = 0x200000;
    public static final int READ_KB_LIMIT = 2048;
    public static final int WRITE_KB_LIMIT = 2048;
    public static final int QUERY_SIZE_LIMIT = 10240;

    public static boolean isUserFailure(int errorCode) {
        return errorCode >= 1 && errorCode <= 49;
    }

    public static boolean isUserThrottling(int errorCode) {
        return errorCode >= 50 && errorCode <= 99;
    }

    public static boolean isServerFailure(int errorCode) {
        return errorCode >= 100;
    }

    public static boolean isServerRetryableFailure(int errorCode) {
        return errorCode >= 100 && errorCode <= 124;
    }

    public static enum OpCode {
        DELETE(0),
        DELETE_IF_VERSION(1),
        GET(2),
        PUT(3),
        PUT_IF_ABSENT(4),
        PUT_IF_PRESENT(5),
        PUT_IF_VERSION(6),
        QUERY(7),
        PREPARE(8),
        WRITE_MULTIPLE(9),
        MULTI_DELETE(10),
        GET_TABLE(11),
        GET_INDEXES(12),
        GET_TABLE_USAGE(13),
        LIST_TABLES(14),
        TABLE_REQUEST(15),
        SCAN(16),
        INDEX_SCAN(17),
        CREATE_TABLE(18),
        ALTER_TABLE(19),
        DROP_TABLE(20),
        CREATE_INDEX(21),
        DROP_INDEX(22),
        SYSTEM_REQUEST(23),
        SYSTEM_STATUS_REQUEST(24);

        private static final OpCode[] VALUES;

        private OpCode(int code) {
            if (code != this.ordinal()) {
                throw new IllegalArgumentException("Wrong op code");
            }
        }

        public static OpCode getOP(int code) {
            try {
                return VALUES[code];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("unknown opcode: " + code);
            }
        }

        public static boolean isTenantOperation(OpCode op) {
            return op == LIST_TABLES || op == CREATE_TABLE;
        }

        static {
            VALUES = OpCode.values();
        }
    }
}

