/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.query;

import java.math.MathContext;
import oracle.nosql.driver.Consistency;
import oracle.nosql.driver.http.Client;
import oracle.nosql.driver.ops.QueryRequest;
import oracle.nosql.driver.ops.RetryStats;
import oracle.nosql.driver.query.PlanIter;
import oracle.nosql.driver.query.PlanIterState;
import oracle.nosql.driver.query.QueryDriver;
import oracle.nosql.driver.query.QueryStateException;
import oracle.nosql.driver.query.TopologyInfo;
import oracle.nosql.driver.values.FieldValue;

public class RuntimeControlBlock {
    private final QueryDriver theQueryDriver;
    private final FieldValue[] theExternalVars;
    private final PlanIter theRootIter;
    private final PlanIterState[] theIteratorStates;
    private final FieldValue[] theRegisters;
    private boolean theReachedLimit;
    private int theReadKB;
    private int theReadUnits;
    private int theWriteKB;
    private int theRateLimitDelayedMs;
    private RetryStats theRetryStats;
    long theMemoryConsumption;

    public RuntimeControlBlock(QueryDriver driver, PlanIter rootIter, int numIters, int numRegs, FieldValue[] externalVars) {
        this.theQueryDriver = driver;
        this.theRootIter = rootIter;
        this.theIteratorStates = new PlanIterState[numIters];
        this.theRegisters = new FieldValue[numRegs];
        this.theExternalVars = externalVars;
    }

    public int getTraceLevel() {
        return this.getRequest().getTraceLevel();
    }

    public void trace(String msg) {
        System.out.println("D-QUERY: " + msg);
    }

    public Client getClient() {
        return this.theQueryDriver.getClient();
    }

    public QueryRequest getRequest() {
        return this.theQueryDriver.getRequest();
    }

    TopologyInfo getTopologyInfo() {
        return this.theQueryDriver.getTopologyInfo();
    }

    Consistency getConsistency() {
        return this.getRequest().getConsistency();
    }

    long getTimeout() {
        return this.getRequest().getTimeout();
    }

    public int getMaxReadKB() {
        return this.getRequest().getMaxReadKB();
    }

    public MathContext getMathContext() {
        return this.getRequest().getMathContext();
    }

    public long getMaxMemoryConsumption() {
        return this.getRequest().getMaxMemoryConsumption();
    }

    void incMemoryConsumption(long v) {
        this.theMemoryConsumption += v;
        assert (this.theMemoryConsumption >= 0L);
        if (this.theMemoryConsumption > this.getMaxMemoryConsumption()) {
            throw new QueryStateException("Memory consumption at the client exceeded maximum allowed value " + this.getMaxMemoryConsumption());
        }
    }

    void decMemoryConsumption(long v) {
        this.theMemoryConsumption -= v;
        assert (this.theMemoryConsumption >= 0L);
    }

    FieldValue[] getExternalVars() {
        return this.theExternalVars;
    }

    FieldValue getExternalVar(int id) {
        if (this.theExternalVars == null) {
            return null;
        }
        return this.theExternalVars[id];
    }

    PlanIter getRootIter() {
        return this.theRootIter;
    }

    public void setState(int pos, PlanIterState state) {
        this.theIteratorStates[pos] = state;
    }

    public PlanIterState getState(int pos) {
        return this.theIteratorStates[pos];
    }

    public FieldValue[] getRegisters() {
        return this.theRegisters;
    }

    public FieldValue getRegVal(int regId) {
        return this.theRegisters[regId];
    }

    public void setRegVal(int regId, FieldValue value) {
        this.theRegisters[regId] = value;
    }

    public void tallyRateLimitDelayedMs(int ms) {
        this.theRateLimitDelayedMs += ms;
    }

    public void tallyRetryStats(RetryStats rs) {
        if (rs == null) {
            return;
        }
        if (this.theRetryStats == null) {
            this.theRetryStats = new RetryStats();
        }
        this.theRetryStats.addStats(rs);
    }

    public void tallyReadKB(int nkb) {
        this.theReadKB += nkb;
    }

    public void tallyReadUnits(int nkb) {
        this.theReadUnits += nkb;
    }

    public void tallyWriteKB(int nkb) {
        this.theWriteKB += nkb;
    }

    public int getReadKB() {
        return this.theReadKB;
    }

    public int getReadUnits() {
        return this.theReadUnits;
    }

    public void resetKBConsumption() {
        this.theReadKB = 0;
        this.theReadUnits = 0;
        this.theWriteKB = 0;
        this.theRateLimitDelayedMs = 0;
        this.theRetryStats = null;
    }

    public int getWriteKB() {
        return this.theWriteKB;
    }

    public RetryStats getRetryStats() {
        return this.theRetryStats;
    }

    public int getRateLimitDelayedMs() {
        return this.theRateLimitDelayedMs;
    }

    public void setReachedLimit(boolean value) {
        this.theReachedLimit = value;
    }

    public boolean reachedLimit() {
        return this.theReachedLimit;
    }
}

