/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.query;

import java.util.ArrayList;
import oracle.nosql.driver.NoSQLException;
import oracle.nosql.driver.RetryableException;
import oracle.nosql.driver.http.Client;
import oracle.nosql.driver.ops.PreparedStatement;
import oracle.nosql.driver.ops.QueryRequest;
import oracle.nosql.driver.ops.QueryResult;
import oracle.nosql.driver.query.PlanIter;
import oracle.nosql.driver.query.RuntimeControlBlock;
import oracle.nosql.driver.query.TopologyInfo;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.MapValue;

public class QueryDriver {
    public static short QUERY_V2 = (short)2;
    public static short QUERY_V3;
    public static short QUERY_VERSION;
    private static final int BATCH_SIZE = 100;
    private static final byte[] DUMMY_CONT_KEY;
    private Client theClient;
    private final QueryRequest theRequest;
    private byte[] theContinuationKey;
    private TopologyInfo theTopologyInfo;
    private int thePrepCost;
    private RuntimeControlBlock theRCB;
    private final int theBatchSize;
    private ArrayList<MapValue> theResults;
    private NoSQLException theError;

    public QueryDriver(QueryRequest req) {
        this.theRequest = req;
        req.setDriver(this);
        this.theBatchSize = req.getLimit() > 0 ? req.getLimit() : 100;
    }

    public void setClient(Client client) {
        this.theClient = client;
    }

    Client getClient() {
        return this.theClient;
    }

    QueryRequest getRequest() {
        return this.theRequest;
    }

    public void setTopologyInfo(TopologyInfo ti) {
        this.theTopologyInfo = ti;
    }

    TopologyInfo getTopologyInfo() {
        return this.theTopologyInfo;
    }

    int numShards() {
        return this.theTopologyInfo.numShards();
    }

    int getShardId(int i) {
        return this.theTopologyInfo.getShardId(i);
    }

    public void setPrepCost(int cost) {
        this.thePrepCost = cost;
    }

    public void compute(QueryResult result) {
        boolean more;
        PreparedStatement prep = this.theRequest.getPreparedStatement();
        assert (!prep.isSimpleQuery());
        assert (this.theRequest.getDriver() == this);
        if (this.theError != null) {
            throw this.theError;
        }
        Client.trace("QueryDriver: starting batch computation", 2);
        if (this.theResults != null) {
            this.setQueryResult(result);
            return;
        }
        PlanIter iter = prep.driverPlan();
        if (this.theRCB == null) {
            this.theRCB = new RuntimeControlBlock(this, iter, prep.numIterators(), prep.numRegisters(), prep.getVariableValues());
            this.theRCB.tallyReadKB(this.thePrepCost);
            this.theRCB.tallyReadUnits(this.thePrepCost);
            iter.open(this.theRCB);
        }
        int i = 0;
        this.theResults = new ArrayList(this.theBatchSize);
        try {
            more = iter.next(this.theRCB);
            while (more) {
                FieldValue res = this.theRCB.getRegVal(iter.getResultReg());
                if (!(res instanceof MapValue)) {
                    throw new IllegalStateException("Query result is not a MapValue:\n" + res);
                }
                this.theResults.add((MapValue)res);
                if (this.theRCB.getTraceLevel() >= 2) {
                    this.theRCB.trace("QueryDriver: got result : " + res);
                }
                if (++i != this.theBatchSize) {
                    more = iter.next(this.theRCB);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            if (!(e instanceof RetryableException)) {
                this.theError = new NoSQLException("QueryRequest cannot be continued after throwing a non-retryable exception in a previous execution. Set the continuation key to null in order to execute the query from the beginning", e);
                iter.close(this.theRCB);
                this.theResults.clear();
                this.theResults = null;
            }
            throw e;
        }
        if (!more) {
            if (this.theRCB.reachedLimit()) {
                this.theContinuationKey = DUMMY_CONT_KEY;
                this.theRCB.setReachedLimit(false);
            } else {
                assert (iter.isDone(this.theRCB));
                this.theContinuationKey = null;
            }
        } else {
            this.theContinuationKey = DUMMY_CONT_KEY;
        }
        this.setQueryResult(result);
        this.theRequest.setContKey(this.theContinuationKey);
    }

    private void setQueryResult(QueryResult result) {
        result.setResults(this.theResults);
        result.setContinuationKey(this.theContinuationKey);
        result.setReadKB(this.theRCB.getReadKB());
        result.setReadUnits(this.theRCB.getReadUnits());
        result.setWriteKB(this.theRCB.getWriteKB());
        result.setRateLimitDelayedMs(this.theRCB.getRateLimitDelayedMs());
        result.setRetryStats(this.theRCB.getRetryStats());
        this.theResults = null;
        this.theRCB.resetKBConsumption();
    }

    public void close() {
        this.theRequest.getPreparedStatement().driverPlan().close(this.theRCB);
        if (this.theResults != null) {
            this.theResults.clear();
            this.theResults = null;
        }
    }

    static {
        QUERY_VERSION = QUERY_V3 = (short)3;
        DUMMY_CONT_KEY = new byte[1];
    }
}

