/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.query;

import java.io.IOException;
import java.math.BigDecimal;
import oracle.nosql.driver.query.PlanIter;
import oracle.nosql.driver.query.PlanIterState;
import oracle.nosql.driver.query.QueryException;
import oracle.nosql.driver.query.QueryFormatter;
import oracle.nosql.driver.query.QueryStateException;
import oracle.nosql.driver.query.RuntimeControlBlock;
import oracle.nosql.driver.util.ByteInputStream;
import oracle.nosql.driver.util.SerializationUtil;
import oracle.nosql.driver.values.DoubleValue;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.IntegerValue;
import oracle.nosql.driver.values.LongValue;
import oracle.nosql.driver.values.NullValue;
import oracle.nosql.driver.values.NumberValue;

public class ArithOpIter
extends PlanIter {
    private final PlanIter.FuncCode theCode;
    private final PlanIter[] theArgs;
    private final String theOps;
    private final transient int theInitResult;
    private final transient boolean theHaveRealDiv;

    public ArithOpIter(ByteInputStream in, short serialVersion) throws IOException {
        super(in, serialVersion);
        short ordinal = in.readShort();
        this.theCode = PlanIter.FuncCode.valueOf(ordinal);
        this.theArgs = ArithOpIter.deserializeIters(in, serialVersion);
        this.theOps = SerializationUtil.readString(in);
        this.theInitResult = this.theCode == PlanIter.FuncCode.OP_ADD_SUB ? 0 : 1;
        this.theHaveRealDiv = this.theOps.contains("d");
        assert (this.theOps.length() == this.theArgs.length) : "Not enough operations: ops:" + (this.theOps.length() - 1) + " args:" + this.theArgs.length;
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.ARITH_OP;
    }

    @Override
    PlanIter.FuncCode getFuncCode() {
        return this.theCode;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new PlanIterState());
        for (PlanIter argIter : this.theArgs) {
            argIter.open(rcb);
        }
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        for (PlanIter argIter : this.theArgs) {
            argIter.reset(rcb);
        }
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        for (PlanIter argIter : this.theArgs) {
            argIter.close(rcb);
        }
        state.close();
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        FieldValue.Type resultType = this.theHaveRealDiv ? FieldValue.Type.DOUBLE : FieldValue.Type.INTEGER;
        block42: for (int i = 0; i < this.theArgs.length; ++i) {
            PlanIter argIter = this.theArgs[i];
            boolean opNext = argIter.next(rcb);
            if (!opNext) {
                state.done();
                return false;
            }
            FieldValue argValue = rcb.getRegVal(argIter.getResultReg());
            if (argValue.isNull()) {
                NullValue res = NullValue.getInstance();
                rcb.setRegVal(this.theResultReg, res);
                state.done();
                return true;
            }
            FieldValue.Type argType = argValue.getType();
            switch (argType) {
                case INTEGER: {
                    continue block42;
                }
                case LONG: {
                    if (resultType != FieldValue.Type.INTEGER) continue block42;
                    resultType = FieldValue.Type.LONG;
                    continue block42;
                }
                case DOUBLE: {
                    if (resultType != FieldValue.Type.INTEGER && resultType != FieldValue.Type.LONG) continue block42;
                    resultType = FieldValue.Type.DOUBLE;
                    continue block42;
                }
                case NUMBER: {
                    resultType = FieldValue.Type.NUMBER;
                    continue block42;
                }
                default: {
                    throw new QueryException("Operand in arithmetic operation has illegal type\nOperand : " + i + " type :\n" + (Object)((Object)argType), this.getLocation());
                }
            }
        }
        int iRes = this.theInitResult;
        long lRes = this.theInitResult;
        double dRes = this.theInitResult;
        BigDecimal nRes = null;
        try {
            block43: for (int i = 0; i < this.theArgs.length; ++i) {
                PlanIter argIter = this.theArgs[i];
                FieldValue argValue = rcb.getRegVal(argIter.getResultReg());
                assert (argValue != null);
                if (this.theCode == PlanIter.FuncCode.OP_ADD_SUB) {
                    if (this.theOps.charAt(i) == '+') {
                        switch (resultType) {
                            case INTEGER: {
                                iRes += argValue.getInt();
                                continue block43;
                            }
                            case LONG: {
                                lRes += argValue.getLong();
                                continue block43;
                            }
                            case DOUBLE: {
                                dRes += argValue.castAsDouble();
                                continue block43;
                            }
                            case NUMBER: {
                                if (nRes == null) {
                                    nRes = argValue.getNumber();
                                    continue block43;
                                }
                                nRes = nRes.add(argValue.getNumber(), rcb.getMathContext());
                                continue block43;
                            }
                            default: {
                                throw new QueryStateException("Invalid result type: " + (Object)((Object)resultType));
                            }
                        }
                    }
                    switch (resultType) {
                        case INTEGER: {
                            iRes -= argValue.getInt();
                            continue block43;
                        }
                        case LONG: {
                            lRes -= argValue.getLong();
                            continue block43;
                        }
                        case DOUBLE: {
                            dRes -= argValue.castAsDouble();
                            continue block43;
                        }
                        case NUMBER: {
                            if (nRes == null) {
                                nRes = argValue.getNumber().negate();
                                continue block43;
                            }
                            nRes = nRes.subtract(argValue.getNumber(), rcb.getMathContext());
                            continue block43;
                        }
                        default: {
                            throw new QueryStateException("Invalid result type: " + (Object)((Object)resultType));
                        }
                    }
                }
                if (this.theOps.charAt(i) == '*') {
                    switch (resultType) {
                        case INTEGER: {
                            iRes *= argValue.getInt();
                            continue block43;
                        }
                        case LONG: {
                            lRes *= argValue.getLong();
                            continue block43;
                        }
                        case DOUBLE: {
                            dRes *= argValue.castAsDouble();
                            continue block43;
                        }
                        case NUMBER: {
                            if (nRes == null) {
                                nRes = argValue.getNumber();
                                continue block43;
                            }
                            nRes = nRes.multiply(argValue.getNumber(), rcb.getMathContext());
                            continue block43;
                        }
                        default: {
                            throw new QueryStateException("Invalid result type: " + (Object)((Object)resultType));
                        }
                    }
                }
                if (this.theOps.charAt(i) == '/') {
                    switch (resultType) {
                        case INTEGER: {
                            iRes /= argValue.getInt();
                            continue block43;
                        }
                        case LONG: {
                            lRes /= argValue.getLong();
                            continue block43;
                        }
                        case DOUBLE: {
                            dRes /= argValue.castAsDouble();
                            continue block43;
                        }
                        case NUMBER: {
                            if (nRes == null) {
                                nRes = new BigDecimal(1);
                            }
                            nRes = nRes.divide(argValue.getNumber(), rcb.getMathContext());
                            continue block43;
                        }
                        default: {
                            throw new QueryStateException("Invalid result type: " + (Object)((Object)resultType));
                        }
                    }
                }
                switch (resultType) {
                    case DOUBLE: {
                        dRes /= argValue.castAsDouble();
                        continue block43;
                    }
                    case NUMBER: {
                        if (nRes == null) {
                            nRes = new BigDecimal(1);
                        }
                        nRes = nRes.divide(argValue.getNumber(), rcb.getMathContext());
                        continue block43;
                    }
                    default: {
                        throw new QueryStateException("Invalid result type: " + (Object)((Object)resultType));
                    }
                }
            }
        }
        catch (ArithmeticException ae) {
            throw new QueryException("Arithmetic exception in query: " + ae.getMessage(), ae, this.getLocation());
        }
        FieldValue res = null;
        switch (resultType) {
            case INTEGER: {
                res = new IntegerValue(iRes);
                break;
            }
            case LONG: {
                res = new LongValue(lRes);
                break;
            }
            case DOUBLE: {
                res = new DoubleValue(dRes);
                break;
            }
            case NUMBER: {
                res = new NumberValue(nRes);
                break;
            }
            default: {
                throw new QueryStateException("Invalid result type: " + (Object)((Object)resultType));
            }
        }
        rcb.setRegVal(this.theResultReg, res);
        state.done();
        return true;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        int i = 0;
        for (PlanIter argIter : this.theArgs) {
            formatter.indent(sb);
            if (this.theCode == PlanIter.FuncCode.OP_ADD_SUB) {
                if (this.theOps.charAt(i) == '+') {
                    sb.append('+');
                } else {
                    sb.append('-');
                }
            } else if (this.theOps.charAt(i) == '*') {
                sb.append('*');
            } else {
                sb.append('/');
            }
            sb.append(",\n");
            argIter.display(sb, formatter);
            if (i < this.theArgs.length - 1) {
                sb.append(",\n");
            }
            ++i;
        }
    }
}

