/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import java.util.ArrayList;
import java.util.List;
import oracle.nosql.driver.Durability;
import oracle.nosql.driver.ops.DeleteRequest;
import oracle.nosql.driver.ops.DurableRequest;
import oracle.nosql.driver.ops.PutRequest;
import oracle.nosql.driver.ops.Request;
import oracle.nosql.driver.ops.WriteRequest;
import oracle.nosql.driver.ops.serde.Serializer;
import oracle.nosql.driver.ops.serde.SerializerFactory;

public class WriteMultipleRequest
extends DurableRequest {
    private final List<OperationRequest> operations = new ArrayList<OperationRequest>();

    public WriteMultipleRequest add(Request request, boolean abortIfUnsuccessful) {
        this.addRequest(request, abortIfUnsuccessful);
        return this;
    }

    public WriteMultipleRequest setCompartment(String compartment) {
        super.setCompartmentInternal(compartment);
        return this;
    }

    public int getTimeout() {
        return super.getTimeoutInternal();
    }

    public int getNumOperations() {
        return this.operations.size();
    }

    public Request getRequest(int index) {
        return this.operations.get(index).getRequest();
    }

    public WriteMultipleRequest setTimeout(int timeoutMs) {
        super.setTimeoutInternal(timeoutMs);
        return this;
    }

    public void clear() {
        super.setTableNameInternal(null);
        this.operations.clear();
    }

    public WriteMultipleRequest setDurability(Durability durability) {
        this.setDurabilityInternal(durability);
        return this;
    }

    @Override
    public Serializer createSerializer(SerializerFactory factory) {
        return factory.createWriteMultipleSerializer();
    }

    @Override
    public Serializer createDeserializer(SerializerFactory factory) {
        return factory.createWriteMultipleDeserializer();
    }

    @Override
    public String getTypeName() {
        return "WriteMultiple";
    }

    @Override
    public void validate() {
        if (this.operations.isEmpty()) {
            throw new IllegalArgumentException("The requests list is empty");
        }
    }

    private void addRequest(Request request, boolean abortIfUnsuccessful) {
        if (!(request instanceof PutRequest) && !(request instanceof DeleteRequest)) {
            throw new IllegalArgumentException("Invalid request, only PutRequest or DeleteRequest is allowed to add: " + request);
        }
        WriteRequest wrReq = (WriteRequest)request;
        if (this.tableName == null) {
            this.tableName = wrReq.getTableName();
        } else if (!wrReq.getTableName().equalsIgnoreCase(this.tableName)) {
            throw new IllegalArgumentException("The tableName used for the operation is different from that of others: " + this.tableName);
        }
        request.validate();
        this.operations.add(new OperationRequest(wrReq, abortIfUnsuccessful));
    }

    public List<OperationRequest> getOperations() {
        return this.operations;
    }

    @Override
    public boolean doesReads() {
        int numops = this.operations.size();
        for (int x = 0; x < numops; ++x) {
            WriteRequest r = this.operations.get(x).getRequest();
            if (!r.doesReads()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean doesWrites() {
        return true;
    }

    @Override
    public boolean shouldRetry() {
        return false;
    }

    public static class OperationRequest {
        private final boolean abortIfUnsuccessful;
        private final WriteRequest request;

        OperationRequest(WriteRequest request, boolean abortIfUnsuccessful) {
            this.request = request;
            this.abortIfUnsuccessful = abortIfUnsuccessful;
        }

        public boolean isAbortIfUnsuccessful() {
            return this.abortIfUnsuccessful;
        }

        public WriteRequest getRequest() {
            return this.request;
        }
    }
}

