/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

public class TableLimits {
    private int readUnits;
    private int writeUnits;
    private int storageGB;
    private CapacityMode mode;

    public TableLimits(int readUnits, int writeUnits, int storageGB) {
        this(readUnits, writeUnits, storageGB, CapacityMode.PROVISIONED);
    }

    public TableLimits(int storageGB) {
        this(0, 0, storageGB, CapacityMode.ON_DEMAND);
    }

    public TableLimits(int readUnits, int writeUnits, int storageGB, CapacityMode mode) {
        this.readUnits = readUnits;
        this.writeUnits = writeUnits;
        this.storageGB = storageGB;
        this.mode = mode;
    }

    public int getReadUnits() {
        return this.readUnits;
    }

    public int getWriteUnits() {
        return this.writeUnits;
    }

    public int getStorageGB() {
        return this.storageGB;
    }

    public CapacityMode getMode() {
        return this.mode;
    }

    public TableLimits setReadUnits(int readUnits) {
        this.readUnits = readUnits;
        return this;
    }

    public TableLimits setWriteUnits(int writeUnits) {
        this.writeUnits = writeUnits;
        return this;
    }

    public TableLimits setStorageGB(int storageGB) {
        this.storageGB = storageGB;
        return this;
    }

    public String toString() {
        return "[" + this.readUnits + ", " + this.writeUnits + ", " + this.storageGB + "]";
    }

    void validate() {
        if (this.storageGB <= 0) {
            throw new IllegalArgumentException("storageGB must be non-negative");
        }
        switch (this.mode) {
            case PROVISIONED: {
                if (this.readUnits > 0 && this.writeUnits > 0) break;
                throw new IllegalArgumentException("readUnits and writeUnits must be non-negative for provisioned capacity table");
            }
            case ON_DEMAND: {
                if (this.readUnits <= 0 && this.writeUnits <= 0) break;
                throw new IllegalArgumentException("Cannot set readUnits or writeUnits for on demand capacity table");
            }
        }
    }

    public static enum CapacityMode {
        PROVISIONED,
        ON_DEMAND;

    }
}

