/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import oracle.nosql.driver.NoSQLHandleConfig;
import oracle.nosql.driver.RateLimiter;
import oracle.nosql.driver.ops.RetryStats;
import oracle.nosql.driver.ops.serde.Serializer;
import oracle.nosql.driver.ops.serde.SerializerFactory;

public abstract class Request {
    protected int timeoutMs;
    protected String tableName;
    protected String compartment;
    private boolean checkRequestSize = true;
    private RetryStats retryStats;
    private long startTimeMs;
    private RateLimiter readRateLimiter;
    private RateLimiter writeRateLimiter;
    private int rateLimitDelayedMs;
    private boolean isRefresh;

    protected Request() {
    }

    public int getTimeoutInternal() {
        return this.timeoutMs;
    }

    public void setTimeoutInternal(int timeoutMs) {
        if (timeoutMs <= 0) {
            throw new IllegalArgumentException("timeout must be > 0");
        }
        this.timeoutMs = timeoutMs;
    }

    public Request setDefaults(NoSQLHandleConfig config) {
        if (this.timeoutMs == 0) {
            this.timeoutMs = config.getDefaultRequestTimeout();
        }
        return this;
    }

    public boolean shouldRetry() {
        return true;
    }

    public boolean isQueryRequest() {
        return false;
    }

    public boolean doesReads() {
        return false;
    }

    public boolean doesWrites() {
        return false;
    }

    public void setCompartmentInternal(String compartment) {
        this.compartment = compartment;
    }

    public String getCompartment() {
        return this.compartment;
    }

    protected void setTableNameInternal(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setReadRateLimiter(RateLimiter rl) {
        this.readRateLimiter = rl;
    }

    public void setWriteRateLimiter(RateLimiter rl) {
        this.writeRateLimiter = rl;
    }

    public RateLimiter getReadRateLimiter() {
        return this.readRateLimiter;
    }

    public RateLimiter getWriteRateLimiter() {
        return this.writeRateLimiter;
    }

    public abstract void validate();

    public abstract Serializer createSerializer(SerializerFactory var1);

    public abstract Serializer createDeserializer(SerializerFactory var1);

    public boolean getCheckRequestSize() {
        return this.checkRequestSize;
    }

    public Request setCheckRequestSize(boolean value) {
        this.checkRequestSize = value;
        return this;
    }

    public RetryStats getRetryStats() {
        return this.retryStats;
    }

    public void setRetryStats(RetryStats rs) {
        this.retryStats = rs;
    }

    public void addRetryException(Class<? extends Throwable> re) {
        if (this.retryStats == null) {
            this.retryStats = new RetryStats();
        }
        this.retryStats.addException(re);
    }

    public void addRetryDelayMs(int millis) {
        if (this.retryStats == null) {
            this.retryStats = new RetryStats();
        }
        this.retryStats.addDelayMs(millis);
    }

    public int getRetryDelayMs() {
        if (this.retryStats == null) {
            return 0;
        }
        return this.retryStats.getDelayMs();
    }

    public void incrementRetries() {
        if (this.retryStats == null) {
            this.retryStats = new RetryStats();
        }
        this.retryStats.incrementRetries();
    }

    public int getNumRetries() {
        if (this.retryStats == null) {
            return 0;
        }
        return this.retryStats.getRetries();
    }

    public void setStartTimeMs(long ms) {
        this.startTimeMs = ms;
    }

    public long getStartTimeMs() {
        return this.startTimeMs;
    }

    public void setRateLimitDelayedMs(int rateLimitDelayedMs) {
        this.rateLimitDelayedMs = rateLimitDelayedMs;
    }

    public int getRateLimitDelayedMs() {
        return this.rateLimitDelayedMs;
    }

    public void setIsRefresh(boolean value) {
        this.isRefresh = value;
    }

    public boolean getIsRefresh() {
        return this.isRefresh;
    }

    public abstract String getTypeName();

    public void copyTo(Request other) {
        other.setTimeoutInternal(this.timeoutMs);
        other.setCheckRequestSize(this.checkRequestSize);
        other.setCompartmentInternal(this.compartment);
        other.setTableNameInternal(this.tableName);
        other.setStartTimeMs(this.startTimeMs);
        other.setRetryStats(this.retryStats);
        other.setReadRateLimiter(this.readRateLimiter);
        other.setWriteRateLimiter(this.writeRateLimiter);
        other.setRateLimitDelayedMs(this.rateLimitDelayedMs);
    }
}

