/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import java.math.MathContext;
import oracle.nosql.driver.Consistency;
import oracle.nosql.driver.NoSQLHandleConfig;
import oracle.nosql.driver.ops.PrepareResult;
import oracle.nosql.driver.ops.PreparedStatement;
import oracle.nosql.driver.ops.Request;
import oracle.nosql.driver.ops.serde.Serializer;
import oracle.nosql.driver.ops.serde.SerializerFactory;
import oracle.nosql.driver.query.QueryDriver;
import oracle.nosql.driver.query.TopologyInfo;

public class QueryRequest
extends Request {
    private int traceLevel;
    private int limit;
    private int maxReadKB;
    private int maxWriteKB;
    private long maxMemoryConsumption = 0x40000000L;
    private MathContext mathContext = MathContext.DECIMAL32;
    private Consistency consistency;
    private String statement;
    private PreparedStatement preparedStatement;
    private byte[] continuationKey;
    private QueryDriver driver;
    private boolean isInternal;
    private int shardId = -1;

    public QueryRequest copyInternal() {
        QueryRequest internalReq = new QueryRequest();
        super.copyTo(internalReq);
        internalReq.traceLevel = this.traceLevel;
        internalReq.limit = this.limit;
        internalReq.maxReadKB = this.maxReadKB;
        internalReq.maxWriteKB = this.maxWriteKB;
        internalReq.maxMemoryConsumption = this.maxMemoryConsumption;
        internalReq.mathContext = this.mathContext;
        internalReq.consistency = this.consistency;
        internalReq.preparedStatement = this.preparedStatement;
        internalReq.isInternal = true;
        internalReq.driver = this.driver;
        return internalReq;
    }

    public QueryDriver getDriver() {
        return this.driver;
    }

    public void setDriver(QueryDriver driver) {
        if (this.driver != null) {
            throw new IllegalArgumentException("QueryRequest is already bound to a QueryDriver");
        }
        this.driver = driver;
    }

    public boolean hasDriver() {
        return this.driver != null;
    }

    public boolean isPrepared() {
        return this.preparedStatement != null;
    }

    public boolean isSimpleQuery() {
        return this.preparedStatement.isSimpleQuery();
    }

    public TopologyInfo topologyInfo() {
        return this.preparedStatement == null ? null : this.preparedStatement.topologyInfo();
    }

    public int topologySeqNum() {
        return this.preparedStatement == null ? -1 : this.preparedStatement.topologySeqNum();
    }

    @Override
    public boolean isQueryRequest() {
        return !this.isInternal;
    }

    @Override
    public boolean doesReads() {
        return true;
    }

    @Override
    public boolean doesWrites() {
        if (this.preparedStatement == null) {
            return false;
        }
        return this.preparedStatement.doesWrites();
    }

    public int getShardId() {
        return this.shardId;
    }

    public void setShardId(int id) {
        this.shardId = id;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public QueryRequest setTraceLevel(int level) {
        if (level > 32) {
            throw new IllegalArgumentException("trace level must be <= 32");
        }
        this.traceLevel = level;
        return this;
    }

    public QueryRequest setCompartment(String compartment) {
        super.setCompartmentInternal(compartment);
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public QueryRequest setLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("limit must be >= 0");
        }
        this.limit = limit;
        return this;
    }

    public int getMaxReadKB() {
        return this.maxReadKB;
    }

    public QueryRequest setMaxReadKB(int maxReadKB) {
        if (maxReadKB < 0) {
            throw new IllegalArgumentException("maxReadKB must be >= 0");
        }
        this.maxReadKB = maxReadKB;
        return this;
    }

    public int getMaxWriteKB() {
        return this.maxWriteKB;
    }

    public QueryRequest setMaxWriteKB(int maxWriteKB) {
        if (maxWriteKB < 0) {
            throw new IllegalArgumentException("maxWriteKB must be >= 0");
        }
        this.maxWriteKB = maxWriteKB;
        return this;
    }

    public QueryRequest setMaxMemoryConsumption(long maxBytes) {
        if (maxBytes < 0L) {
            throw new IllegalArgumentException("maxBytes must be >= 0");
        }
        this.maxMemoryConsumption = maxBytes;
        return this;
    }

    public long getMaxMemoryConsumption() {
        return this.maxMemoryConsumption;
    }

    public MathContext getMathContext() {
        return this.mathContext;
    }

    public QueryRequest setMathContext(MathContext mathContext) {
        if (mathContext == null) {
            throw new IllegalArgumentException("mathContext can not be null");
        }
        this.mathContext = mathContext;
        return this;
    }

    public String getStatement() {
        return this.statement;
    }

    public QueryRequest setStatement(String statement) {
        if (statement != null && this.preparedStatement != null && !statement.equals(this.preparedStatement.getSQLText())) {
            throw new IllegalArgumentException("The query text is not equal to the prepared one");
        }
        this.statement = statement;
        return this;
    }

    public PreparedStatement getPreparedStatement() {
        return this.preparedStatement;
    }

    public QueryRequest setPreparedStatement(PreparedStatement preparedStatement) {
        if (this.statement != null && preparedStatement != null && !this.statement.equals(preparedStatement.getSQLText())) {
            throw new IllegalArgumentException("The query text is not equal to the prepared one");
        }
        this.preparedStatement = preparedStatement;
        return this;
    }

    public QueryRequest setPreparedStatement(PrepareResult prepareResult) {
        this.preparedStatement = prepareResult.getPreparedStatement();
        return this;
    }

    @Deprecated
    public byte[] getContinuationKey() {
        return this.continuationKey;
    }

    @Deprecated
    public QueryRequest setContinuationKey(byte[] continuationKey) {
        return this.setContKey(continuationKey);
    }

    public byte[] getContKey() {
        return this.continuationKey;
    }

    public QueryRequest setContKey(byte[] continuationKey) {
        this.continuationKey = continuationKey;
        if (this.driver != null && !this.isInternal && continuationKey == null) {
            this.driver.close();
            this.driver = null;
        }
        return this;
    }

    public boolean isDone() {
        return this.continuationKey == null;
    }

    public void close() {
        this.setContinuationKey(null);
    }

    public QueryRequest setConsistency(Consistency consistency) {
        this.consistency = consistency;
        return this;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    public QueryRequest setTimeout(int timeoutMs) {
        super.setTimeoutInternal(timeoutMs);
        return this;
    }

    public int getTimeout() {
        return super.getTimeoutInternal();
    }

    @Override
    public Serializer createSerializer(SerializerFactory factory) {
        return factory.createQuerySerializer();
    }

    @Override
    public Serializer createDeserializer(SerializerFactory factory) {
        return factory.createQueryDeserializer();
    }

    @Override
    public String getTypeName() {
        return "Query";
    }

    @Override
    public Request setDefaults(NoSQLHandleConfig config) {
        super.setDefaults(config);
        if (this.consistency == null) {
            this.consistency = config.getDefaultConsistency();
        }
        return this;
    }

    @Override
    public void validate() {
        if (this.statement == null && this.preparedStatement == null) {
            throw new IllegalArgumentException("Either statement or prepared statement should be set");
        }
    }

    @Override
    public String getTableName() {
        if (this.preparedStatement == null) {
            return null;
        }
        return this.preparedStatement.getTableName();
    }

    @Override
    public boolean shouldRetry() {
        return false;
    }
}

