/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.iam;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.util.logging.Logger;
import oracle.nosql.driver.iam.SecurityTokenSupplier;
import oracle.nosql.driver.iam.SessionKeyPairSupplier;
import oracle.nosql.driver.iam.Utils;

abstract class ResourcePrincipalTokenSupplier {
    protected long minTokenLifetime;

    ResourcePrincipalTokenSupplier() {
    }

    abstract String getSecurityToken();

    abstract String getStringClaim(String var1);

    void setMinTokenLifetime(long lifetimeMS) {
        this.minTokenLifetime = lifetimeMS;
    }

    static class FixedSecurityTokenSupplier
    extends ResourcePrincipalTokenSupplier {
        private final SecurityTokenSupplier.SecurityToken securityToken;

        FixedSecurityTokenSupplier(SessionKeyPairSupplier sessionKeySupplier, String sessionToken) {
            this.securityToken = new SecurityTokenSupplier.SecurityToken(sessionToken, sessionKeySupplier);
        }

        @Override
        public String getSecurityToken() {
            this.securityToken.validate(this.minTokenLifetime);
            return this.securityToken.getSecurityToken();
        }

        @Override
        public String getStringClaim(String key) {
            return this.securityToken.getStringClaim(key);
        }
    }

    static class FileSecurityTokenSupplier
    extends ResourcePrincipalTokenSupplier {
        private final SessionKeyPairSupplier sessionKeyPairSupplier;
        private final String sessionTokenPath;
        private volatile SecurityTokenSupplier.SecurityToken securityToken;
        private Logger logger;

        FileSecurityTokenSupplier(SessionKeyPairSupplier sessKeyPairSupplier, String sessionTokenPath, Logger logger) {
            this.sessionKeyPairSupplier = sessKeyPairSupplier;
            this.sessionTokenPath = sessionTokenPath;
            this.logger = logger;
        }

        @Override
        public String getSecurityToken() {
            return this.refreshAndGetSecurityToken();
        }

        @Override
        public String getStringClaim(String key) {
            if (this.securityToken == null) {
                this.refreshAndGetSecurityToken();
            }
            return this.securityToken.getStringClaim(key);
        }

        private synchronized String refreshAndGetSecurityToken() {
            Utils.logTrace(this.logger, "Refreshing session keys");
            this.sessionKeyPairSupplier.refreshKeys();
            Utils.logTrace(this.logger, "Getting security token from file.");
            SecurityTokenSupplier.SecurityToken token = this.getSecurityTokenFromFile();
            token.validate(this.minTokenLifetime);
            this.securityToken = token;
            return this.securityToken.getSecurityToken();
        }

        SecurityTokenSupplier.SecurityToken getSecurityTokenFromFile() {
            KeyPair keyPair = this.sessionKeyPairSupplier.getKeyPair();
            if (keyPair == null) {
                throw new IllegalArgumentException("Keypair for session was not provided");
            }
            String sessToken = null;
            try {
                sessToken = new String(Files.readAllBytes(Paths.get(this.sessionTokenPath, new String[0])), Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read session token from " + this.sessionTokenPath, e);
            }
            return new SecurityTokenSupplier.SecurityToken(sessToken, this.sessionKeyPairSupplier);
        }
    }
}

