/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.iam;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.logging.Logger;
import oracle.nosql.driver.Region;
import oracle.nosql.driver.iam.AuthenticationProfileProvider;
import oracle.nosql.driver.iam.ResourcePrincipalTokenSupplier;
import oracle.nosql.driver.iam.SecurityTokenSupplier;
import oracle.nosql.driver.iam.SessionKeyPairSupplier;

class ResourcePrincipalProvider
implements AuthenticationProfileProvider,
Region.RegionProvider,
SecurityTokenSupplier.SecurityTokenBasedProvider {
    private static final String OCI_RESOURCE_PRINCIPAL_VERSION = "OCI_RESOURCE_PRINCIPAL_VERSION";
    private static final String RP_VERSION_2_2 = "2.2";
    private static final String OCI_RESOURCE_PRINCIPAL_RPST = "OCI_RESOURCE_PRINCIPAL_RPST";
    private static final String OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM = "OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM";
    private static final String OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE = "OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE";
    private static final String OCI_RESOURCE_PRINCIPAL_REGION = "OCI_RESOURCE_PRINCIPAL_REGION";
    private final ResourcePrincipalTokenSupplier tokenSupplier;
    private final SessionKeyPairSupplier.DefaultSessionKeySupplier sessionKeySupplier;
    private final Region region;

    public static ResourcePrincipalProvider build(Logger logger) {
        SessionKeyPairSupplier sessKeySupplier;
        String version;
        if (logger == null) {
            logger = Logger.getLogger(ResourcePrincipalProvider.class.getName());
        }
        if ((version = System.getenv(OCI_RESOURCE_PRINCIPAL_VERSION)) == null) {
            throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_VERSION environment variable missing");
        }
        if (!version.equals(RP_VERSION_2_2)) {
            throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_VERSION has unknown value " + version);
        }
        String rpPrivateKey = System.getenv(OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM);
        String kp = System.getenv(OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE);
        if (rpPrivateKey == null) {
            throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM environment variable missing");
        }
        if (new File(rpPrivateKey).isAbsolute()) {
            if (kp != null && !new File(kp).isAbsolute()) {
                throw new IllegalArgumentException("cannot mix path and constant settings for OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM and OCI_RESOURCE_PRINCIPAL_PRIVATE_PEM_PASSPHRASE");
            }
            sessKeySupplier = new SessionKeyPairSupplier.FileKeyPairSupplier(rpPrivateKey, kp);
        } else {
            char[] passPhraseChars = null;
            if (kp != null) {
                passPhraseChars = kp.toCharArray();
            }
            sessKeySupplier = new SessionKeyPairSupplier.FixedKeyPairSupplier(rpPrivateKey, passPhraseChars);
        }
        String rpst = System.getenv(OCI_RESOURCE_PRINCIPAL_RPST);
        if (rpst == null) {
            throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_RPST environment variable missing");
        }
        ResourcePrincipalTokenSupplier tokenSupplier = new File(rpst).isAbsolute() ? new ResourcePrincipalTokenSupplier.FileSecurityTokenSupplier(sessKeySupplier, rpst, logger) : new ResourcePrincipalTokenSupplier.FixedSecurityTokenSupplier(sessKeySupplier, rpst);
        String rpRegion = System.getenv(OCI_RESOURCE_PRINCIPAL_REGION);
        if (rpRegion == null) {
            throw new IllegalArgumentException("OCI_RESOURCE_PRINCIPAL_REGION environment variable missing");
        }
        Region r = Region.fromRegionId(rpRegion);
        return new ResourcePrincipalProvider(tokenSupplier, sessKeySupplier, r);
    }

    ResourcePrincipalProvider(ResourcePrincipalTokenSupplier tkSupplier, SessionKeyPairSupplier keyPairSupplier, Region region) {
        this.tokenSupplier = tkSupplier;
        this.sessionKeySupplier = new SessionKeyPairSupplier.DefaultSessionKeySupplier(keyPairSupplier);
        this.region = region;
    }

    @Override
    public String getKeyId() {
        return "ST$" + this.tokenSupplier.getSecurityToken();
    }

    @Override
    public InputStream getPrivateKey() {
        return new ByteArrayInputStream(this.sessionKeySupplier.getPrivateKeyBytes());
    }

    @Override
    public char[] getPassphraseCharacters() {
        return null;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public void setMinTokenLifetime(long lifetimeMS) {
        this.tokenSupplier.setMinTokenLifetime(lifetimeMS);
    }

    String getClaim(String key) {
        return this.tokenSupplier.getStringClaim(key);
    }
}

