/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.httpclient;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import oracle.nosql.driver.NoSQLHandleConfig;
import oracle.nosql.driver.httpclient.ConnectionPool;
import oracle.nosql.driver.httpclient.HttpClientChannelPoolHandler;
import oracle.nosql.driver.httpclient.RequestState;
import oracle.nosql.driver.httpclient.ResponseHandler;
import oracle.nosql.driver.util.LogUtil;

public class HttpClient {
    static final int DEFAULT_MAX_CONTENT_LENGTH = 0x2000000;
    static final int DEFAULT_MAX_CHUNK_SIZE = 65536;
    static final int DEFAULT_HANDSHAKE_TIMEOUT_MS = 3000;
    static final int DEFAULT_MIN_POOL_SIZE = 2;
    static final AttributeKey<RequestState> STATE_KEY = AttributeKey.valueOf("rqstate");
    private final ConnectionPool pool;
    private final HttpClientChannelPoolHandler poolHandler;
    private final int maxContentLength;
    private final int maxChunkSize;
    private final String host;
    private final int port;
    private final String name;
    private final int acquireRetryIntervalMs;
    private final SslContext sslCtx;
    private final int handshakeTimeoutMs;
    private final Logger logger;
    private String proxyHost;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    final NioEventLoopGroup workerGroup;

    public static HttpClient createMinimalClient(String host, int port, SslContext sslCtx, int handshakeTimeoutMs, String name, Logger logger) {
        return new HttpClient(host, port, 1, 0, 0, true, 0x2000000, 65536, sslCtx, handshakeTimeoutMs, name, logger);
    }

    public HttpClient(String host, int port, int numThreads, int connectionPoolMinSize, int inactivityPeriodSeconds, int maxContentLength, int maxChunkSize, SslContext sslCtx, int handshakeTimeoutMs, String name, Logger logger) {
        this(host, port, numThreads, connectionPoolMinSize, inactivityPeriodSeconds, false, maxContentLength, maxChunkSize, sslCtx, handshakeTimeoutMs, name, logger);
    }

    private HttpClient(String host, int port, int numThreads, int connectionPoolMinSize, int inactivityPeriodSeconds, boolean isMinimalClient, int maxContentLength, int maxChunkSize, SslContext sslCtx, int handshakeTimeoutMs, String name, Logger logger) {
        this.logger = logger;
        this.sslCtx = sslCtx;
        this.host = host;
        this.port = port;
        this.name = name;
        this.maxContentLength = maxContentLength == 0 ? 0x2000000 : maxContentLength;
        this.maxChunkSize = maxChunkSize == 0 ? 65536 : maxChunkSize;
        this.handshakeTimeoutMs = handshakeTimeoutMs == 0 ? 3000 : handshakeTimeoutMs;
        int cores = Runtime.getRuntime().availableProcessors();
        if (numThreads == 0) {
            numThreads = cores * 2;
        }
        if (connectionPoolMinSize == 0) {
            connectionPoolMinSize = 2;
        } else if (connectionPoolMinSize < 0) {
            connectionPoolMinSize = 0;
        }
        this.workerGroup = new NioEventLoopGroup(numThreads);
        Bootstrap b = new Bootstrap();
        b.group((EventLoopGroup)this.workerGroup);
        b.channel(NioSocketChannel.class);
        b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        b.option(ChannelOption.TCP_NODELAY, (Object)true);
        b.remoteAddress(host, port);
        this.poolHandler = new HttpClientChannelPoolHandler(this);
        this.pool = new ConnectionPool(b, this.poolHandler, logger, isMinimalClient, connectionPoolMinSize, inactivityPeriodSeconds);
        if (!isMinimalClient && connectionPoolMinSize > 0) {
            this.pool.setKeepAlive(new ConnectionPool.KeepAlive(){

                @Override
                public boolean keepAlive(Channel ch) {
                    return HttpClient.this.doKeepAlive(ch);
                }
            });
        }
        this.acquireRetryIntervalMs = Integer.getInteger("oracle.nosql.driver.acquire.retryinterval", 1000);
    }

    SslContext getSslContext() {
        return this.sslCtx;
    }

    int getPort() {
        return this.port;
    }

    String getHost() {
        return this.host;
    }

    String getName() {
        return this.name;
    }

    Logger getLogger() {
        return this.logger;
    }

    int getHandshakeTimeoutMs() {
        return this.handshakeTimeoutMs;
    }

    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public void configureProxy(NoSQLHandleConfig config) {
        this.proxyHost = config.getProxyHost();
        this.proxyPort = config.getProxyPort();
        this.proxyUsername = config.getProxyUsername();
        this.proxyPassword = config.getProxyPassword();
        if (this.proxyHost != null && this.proxyPort == 0 || this.proxyHost == null && this.proxyPort != 0) {
            throw new IllegalArgumentException("To configure an HTTP proxy, both host and port are required");
        }
        if (this.proxyUsername != null && this.proxyPassword == null || this.proxyUsername == null && this.proxyPassword != null) {
            throw new IllegalArgumentException("To configure HTTP proxy authentication, both user name and password are required");
        }
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public int getAcquiredChannelCount() {
        return this.pool.getAcquiredChannelCount();
    }

    public int getTotalChannelCount() {
        return this.pool.getTotalChannels();
    }

    public int getFreeChannelCount() {
        return this.pool.getFreeChannels();
    }

    ConnectionPool getConnectionPool() {
        return this.pool;
    }

    public void shutdown() {
        this.pool.close();
        this.workerGroup.shutdownGracefully().syncUninterruptibly();
    }

    public Channel getChannel(int timeoutMs) throws InterruptedException, ExecutionException, TimeoutException {
        long startMs;
        long now = startMs = System.currentTimeMillis();
        int retries = 0;
        while (true) {
            Channel retChan;
            Future<Channel> fut;
            block9: {
                long msDiff;
                long thisTimeoutMs;
                if ((thisTimeoutMs = (long)timeoutMs - (msDiff = now - startMs)) <= 0L) {
                    String msg = "Timed out after " + msDiff + "ms (" + retries + " retries) trying " + "to acquire channel";
                    LogUtil.logInfo(this.logger, "HttpClient " + this.name + " " + msg);
                    throw new TimeoutException(msg);
                }
                if (thisTimeoutMs > (long)this.acquireRetryIntervalMs) {
                    thisTimeoutMs = this.acquireRetryIntervalMs;
                }
                fut = this.pool.acquire();
                retChan = null;
                try {
                    retChan = (Channel)fut.get(thisTimeoutMs, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    if (retries != 0) break block9;
                    LogUtil.logInfo(this.logger, "Timed out after " + (System.currentTimeMillis() - startMs) + "ms trying to acquire channel: retrying");
                }
            }
            if (retChan != null) {
                if (fut.isSuccess() && retChan.isActive()) {
                    if (retChan.attr(STATE_KEY).get() != null) {
                        if (LogUtil.isFineEnabled(this.logger)) {
                            LogUtil.logFine(this.logger, "HttpClient acquired a channel with a still-active state: clearing.");
                        }
                        retChan.attr(STATE_KEY).set(null);
                    }
                    return retChan;
                }
                LogUtil.logFine(this.logger, "HttpClient " + this.name + ", acquired an inactive " + "channel, releasing it and retrying, reason: " + fut.cause());
                this.releaseChannel(retChan);
            }
            now = System.currentTimeMillis();
            ++retries;
        }
    }

    public void releaseChannel(Channel channel) {
        channel.attr(STATE_KEY).set(null);
        this.pool.release(channel);
    }

    public void runRequest(HttpRequest request, final ResponseHandler handler, Channel channel) throws IOException {
        if (!channel.isActive()) {
            String msg = "HttpClient " + this.name + ", runRequest, channel " + channel + " is not active: ";
            LogUtil.logWarning(this.logger, msg);
            throw new IOException(msg);
        }
        RequestState state = new RequestState(handler);
        channel.attr(STATE_KEY).set(state);
        channel.writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                if (!future.isSuccess()) {
                    handler.handleException("HttpClient: send failed", future.cause());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doKeepAlive(Channel ch) {
        int keepAliveTimeout = 3000;
        ResponseHandler responseHandler = new ResponseHandler(this, this.logger, ch);
        try {
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.HEAD, "/");
            request.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)this.host);
            this.runRequest((HttpRequest)request, responseHandler, ch);
            boolean isTimeout = responseHandler.await(3000);
            if (isTimeout) {
                LogUtil.logFine(this.logger, "Timeout on keepalive HEAD request on channel " + ch);
                boolean bl = false;
                return bl;
            }
            String conn = responseHandler.getHeaders().get("Connection");
            if (conn == null || !"keep-alive".equalsIgnoreCase(conn)) {
                LogUtil.logFine(this.logger, "Keepalive HEAD request did not return keep-alive in connection header, is: " + conn);
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            LogUtil.logFine(this.logger, "Exception sending HTTP HEAD: " + t);
        }
        finally {
            responseHandler.releaseResponse();
        }
        return false;
    }
}

