/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.values;

import com.fasterxml.jackson.core.io.CharTypes;
import java.math.BigDecimal;
import oracle.nosql.driver.util.CheckNull;
import oracle.nosql.driver.util.SizeOf;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.JsonOptions;

public class StringValue
extends FieldValue {
    private final String value;

    public StringValue(String value) {
        CheckNull.requireNonNull(value, "StringValue: value must be non-null");
        this.value = value;
    }

    @Override
    public FieldValue.Type getType() {
        return FieldValue.Type.STRING;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public int getInt() {
        return Integer.parseInt(this.value);
    }

    @Override
    public double getDouble() {
        return Double.parseDouble(this.value);
    }

    @Override
    public long getLong() {
        return Long.parseLong(this.value);
    }

    @Override
    public BigDecimal getNumber() {
        return new BigDecimal(this.value);
    }

    @Override
    public boolean getBoolean() {
        return Boolean.parseBoolean(this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof StringValue) {
            return this.value.equals(((StringValue)other).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof StringValue) {
            return this.value.compareTo(other.asString().getValue());
        }
        throw new ClassCastException("Object is not an StringValue");
    }

    @Override
    public String toJson(JsonOptions options) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        CharTypes.appendQuoted(sb, this.value);
        sb.append("\"");
        return sb.toString();
    }

    @Override
    public long sizeof() {
        return SizeOf.OBJECT_OVERHEAD + SizeOf.OBJECT_REF_OVERHEAD + SizeOf.stringSize(this.value);
    }
}

