/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import java.util.HashMap;
import java.util.Map;
import oracle.nosql.driver.query.PlanIter;
import oracle.nosql.driver.query.TopologyInfo;
import oracle.nosql.driver.values.FieldValue;

public class PreparedStatement {
    private final String sqlText;
    private final String queryPlan;
    private volatile TopologyInfo topologyInfo;
    private final byte[] proxyStatement;
    private final PlanIter driverQueryPlan;
    private final int numRegisters;
    private final int numIterators;
    private final Map<String, Integer> variables;
    private Map<String, FieldValue> boundVariables;
    private final String namespace;
    private final String tableName;
    private final byte operation;
    private final byte OPCODE_SELECT = (byte)5;

    public PreparedStatement(String sqlText, String queryPlan, TopologyInfo ti, byte[] proxyStatement, PlanIter driverPlan, int numIterators, int numRegisters, Map<String, Integer> externalVars, String namespace, String tableName, byte operation) {
        if (proxyStatement == null || proxyStatement.length < 10) {
            throw new IllegalArgumentException("Invalid prepared query, cannot be null");
        }
        this.sqlText = sqlText;
        this.queryPlan = queryPlan;
        this.topologyInfo = ti;
        this.proxyStatement = proxyStatement;
        this.driverQueryPlan = driverPlan;
        this.numIterators = numIterators;
        this.numRegisters = numRegisters;
        this.variables = externalVars;
        this.namespace = namespace;
        this.tableName = tableName;
        this.operation = operation;
    }

    public PreparedStatement copyStatement() {
        return new PreparedStatement(this.sqlText, this.queryPlan, this.topologyInfo, this.proxyStatement, this.driverQueryPlan, this.numIterators, this.numRegisters, this.variables, this.namespace, this.tableName, this.operation);
    }

    public String getSQLText() {
        return this.sqlText;
    }

    public String getQueryPlan() {
        return this.queryPlan;
    }

    public Map<String, FieldValue> getVariables() {
        return this.boundVariables;
    }

    public FieldValue[] getVariableValues() {
        if (this.boundVariables == null) {
            return null;
        }
        FieldValue[] values = new FieldValue[this.boundVariables.size()];
        for (Map.Entry<String, FieldValue> entry : this.boundVariables.entrySet()) {
            int varid = this.variables.get(entry.getKey());
            values[varid] = entry.getValue();
        }
        return values;
    }

    public void clearVariables() {
        if (this.boundVariables != null) {
            this.boundVariables.clear();
        }
    }

    public PreparedStatement setVariable(String name, FieldValue value) {
        if (this.boundVariables == null) {
            this.boundVariables = new HashMap<String, FieldValue>();
        }
        if (this.variables != null && this.variables.get(name) == null) {
            throw new IllegalArgumentException("The query does not contain the variable: " + name);
        }
        this.boundVariables.put(name, value);
        return this;
    }

    public PreparedStatement setVariable(int pos, FieldValue value) {
        if (this.variables == null) {
            String name = "#" + pos;
            return this.setVariable(name, value);
        }
        int searchId = pos - 1;
        for (Map.Entry<String, Integer> entry : this.variables.entrySet()) {
            int id = entry.getValue();
            if (id != searchId) continue;
            return this.setVariable(entry.getKey(), value);
        }
        throw new IllegalArgumentException("There is no external variable at position " + pos);
    }

    public final byte[] getStatement() {
        return this.proxyStatement;
    }

    public String printDriverPlan() {
        if (this.driverQueryPlan != null) {
            return this.driverQueryPlan.display();
        }
        return null;
    }

    public PlanIter driverPlan() {
        return this.driverQueryPlan;
    }

    public boolean isSimpleQuery() {
        return this.driverQueryPlan == null;
    }

    public int numRegisters() {
        return this.numRegisters;
    }

    public int numIterators() {
        return this.numIterators;
    }

    public synchronized int topologySeqNum() {
        return this.topologyInfo == null ? -1 : this.topologyInfo.getSeqNum();
    }

    public synchronized PreparedStatement setTopologyInfo(TopologyInfo ti) {
        if (ti == null) {
            return this;
        }
        if (this.topologyInfo == null) {
            this.topologyInfo = ti;
            return this;
        }
        if (this.topologyInfo.getSeqNum() < ti.getSeqNum()) {
            this.topologyInfo = ti;
        }
        return this;
    }

    public TopologyInfo topologyInfo() {
        return this.topologyInfo;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean doesWrites() {
        return this.operation != 5;
    }
}

