/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.iam;

import java.io.InputStream;
import java.util.function.Supplier;
import oracle.nosql.driver.Region;
import oracle.nosql.driver.iam.UserAuthenticationProfileProvider;
import oracle.nosql.driver.iam.Utils;
import oracle.nosql.driver.util.CheckNull;

class SimpleProfileProvider
implements UserAuthenticationProfileProvider,
Region.RegionProvider {
    private final String tenantId;
    private final String userId;
    private final String fingerprint;
    private final char[] passphrase;
    private final Region region;
    private final Supplier<InputStream> privateKeySupplier;

    public static SimpleProfileProviderBuilder builder() {
        return new SimpleProfileProviderBuilder();
    }

    private SimpleProfileProvider(String tenantId, String userId, String fingerprint, char[] passphrase, Supplier<InputStream> privateKeySupplier, Region region) {
        this.tenantId = tenantId;
        this.userId = userId;
        this.fingerprint = fingerprint;
        this.passphrase = passphrase;
        this.privateKeySupplier = privateKeySupplier;
        this.region = region;
    }

    @Override
    public String getKeyId() {
        CheckNull.requireNonNullIAE(this.tenantId, "SimpleProfileProvider is missing tenantId");
        CheckNull.requireNonNullIAE(this.userId, "SimpleProfileProvider is missing userId");
        if (!Utils.isValidOcid(this.getTenantId())) {
            throw new IllegalArgumentException("Tenant Id" + this.getTenantId() + "does not match OCID pattern");
        }
        if (!Utils.isValidOcid(this.getUserId())) {
            throw new IllegalArgumentException("User Id" + this.getUserId() + "does not match OCID pattern");
        }
        String keyId = Utils.createKeyId(this);
        return keyId;
    }

    @Override
    public InputStream getPrivateKey() {
        return this.privateKeySupplier.get();
    }

    @Override
    public char[] getPassphraseCharacters() {
        return this.passphrase;
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    public String toString() {
        return String.format("SimpleProfileProvider(tenantId=%s, userId=%s, fingerprint=%s,passphraseCharacters=%s, privateKeySupplier=%s)", this.tenantId, this.userId, this.fingerprint, this.passphrase != null ? "<provided>" : (Object)this.passphrase, this.privateKeySupplier);
    }

    public static class SimpleProfileProviderBuilder {
        private String tenantId;
        private String userId;
        private String fingerprint;
        private char[] passphrase;
        private Supplier<InputStream> privateKeySupplier;
        private Region region;

        public SimpleProfileProviderBuilder tenantId(String tid) {
            this.tenantId = tid;
            return this;
        }

        public SimpleProfileProviderBuilder userId(String uid) {
            this.userId = uid;
            return this;
        }

        public SimpleProfileProviderBuilder fingerprint(String fp) {
            this.fingerprint = fp;
            return this;
        }

        public SimpleProfileProviderBuilder passphrase(char[] ph) {
            this.passphrase = ph;
            return this;
        }

        public SimpleProfileProviderBuilder region(Region r) {
            this.region = r;
            return this;
        }

        public SimpleProfileProviderBuilder privateKeySupplier(Supplier<InputStream> pks) {
            this.privateKeySupplier = pks;
            return this;
        }

        public SimpleProfileProvider build() {
            return new SimpleProfileProvider(this.tenantId, this.userId, this.fingerprint, this.passphrase, this.privateKeySupplier, this.region);
        }
    }
}

