/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.iam;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import oracle.nosql.driver.Region;
import oracle.nosql.driver.iam.OCIConfigFileReader;
import oracle.nosql.driver.iam.PrivateKeyFileSupplier;
import oracle.nosql.driver.iam.SimpleProfileProvider;
import oracle.nosql.driver.iam.UserAuthenticationProfileProvider;
import oracle.nosql.driver.iam.Utils;
import oracle.nosql.driver.util.CheckNull;

class OCIConfigFileProvider
implements UserAuthenticationProfileProvider,
Region.RegionProvider {
    public static final String DEFAULT_FILE_PATH = System.getProperty("user.home") + File.separator + ".oci" + File.separator + "config";
    public static final String DEFAULT_PROFILE_NAME = "DEFAULT";
    static final String FINGERPRINT_PROP = "fingerprint";
    static final String TENANCY_PROP = "tenancy";
    static final String USER_PROP = "user";
    static final String KEY_FILE_PROP = "key_file";
    static final String PASSPHRASE_PROP = "pass_phrase";
    static final String REGION_PROP = "region";
    private final SimpleProfileProvider delegate;

    public OCIConfigFileProvider() throws IOException {
        this(OCIConfigFileReader.parse(DEFAULT_FILE_PATH, DEFAULT_PROFILE_NAME));
    }

    public OCIConfigFileProvider(String profile) throws IOException {
        this(OCIConfigFileReader.parse(DEFAULT_FILE_PATH, profile));
    }

    public OCIConfigFileProvider(String configurationFilePath, String profile) throws IOException {
        this(OCIConfigFileReader.parse(configurationFilePath, profile));
    }

    private OCIConfigFileProvider(OCIConfigFileReader.OCIConfigFile configFile) {
        String regionValue;
        String fingerprint = configFile.get(FINGERPRINT_PROP);
        CheckNull.requireNonNullIAE(fingerprint, this.missing(FINGERPRINT_PROP));
        String tenantId = configFile.get(TENANCY_PROP);
        CheckNull.requireNonNullIAE(tenantId, this.missing(TENANCY_PROP));
        String userId = configFile.get(USER_PROP);
        CheckNull.requireNonNullIAE(userId, this.missing(USER_PROP));
        String pemFilePath = configFile.get(KEY_FILE_PROP);
        CheckNull.requireNonNullIAE(pemFilePath, this.missing(KEY_FILE_PROP));
        String passPhrase = configFile.get(PASSPHRASE_PROP);
        PrivateKeyFileSupplier privateKeySupplier = new PrivateKeyFileSupplier(new File(Utils.expandUserHome(pemFilePath)));
        SimpleProfileProvider.SimpleProfileProviderBuilder builder = SimpleProfileProvider.builder().fingerprint(fingerprint).privateKeySupplier(privateKeySupplier).tenantId(tenantId).userId(userId);
        if (passPhrase != null) {
            builder = builder.passphrase(passPhrase.toCharArray());
        }
        if ((regionValue = configFile.get(REGION_PROP)) != null) {
            builder.region(Region.fromRegionId(regionValue));
        }
        this.delegate = builder.build();
    }

    @Override
    public String getFingerprint() {
        return this.delegate.getFingerprint();
    }

    @Override
    public String getTenantId() {
        return this.delegate.getTenantId();
    }

    @Override
    public String getUserId() {
        return this.delegate.getUserId();
    }

    @Override
    public char[] getPassphraseCharacters() {
        return this.delegate.getPassphraseCharacters();
    }

    @Override
    public InputStream getPrivateKey() {
        return this.delegate.getPrivateKey();
    }

    @Override
    public String getKeyId() {
        return this.delegate.getKeyId();
    }

    @Override
    public Region getRegion() {
        return this.delegate.getRegion();
    }

    private String missing(String propertyName) {
        return "Required property " + propertyName + " is missing from OCI configuration file";
    }
}

