/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.values;

import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.JsonOptions;

public class JsonNullValue
extends FieldValue {
    private static final JsonNullValue INSTANCE = new JsonNullValue();

    private JsonNullValue() {
    }

    @Override
    public FieldValue.Type getType() {
        return FieldValue.Type.JSON_NULL;
    }

    public static JsonNullValue getInstance() {
        return INSTANCE;
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof JsonNullValue) {
            return 0;
        }
        return -1;
    }

    @Override
    public String getString() {
        return this.toJson(null);
    }

    @Override
    public String toJson(JsonOptions options) {
        return "null";
    }

    public boolean equals(Object other) {
        return other == INSTANCE;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public long sizeof() {
        return 0L;
    }
}

