/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.util;

import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberUtil {
    private static final byte TERMINATOR = -1;
    private static final byte ZERO = NumberUtil.excess128(0);
    private static final byte[] BYTES_ZERO = new byte[]{ZERO};

    public static byte[] serialize(BigDecimal value) {
        if (value.compareTo(BigDecimal.ZERO) == 0) {
            return BYTES_ZERO;
        }
        BigDecimal decimal = value.stripTrailingZeros();
        int sign = decimal.signum();
        String mantissa = decimal.unscaledValue().abs().toString();
        int exponent = mantissa.length() - 1 - decimal.scale();
        return NumberUtil.writeBytes(sign, exponent, mantissa);
    }

    public static BigDecimal deserialize(byte[] bytes) {
        byte byte0;
        if (bytes == null || bytes.length == 0) {
            throw new IllegalStateException("Leading bytes should be null or empty");
        }
        int offset = 0;
        if (!NumberUtil.isValidLeadingByte(byte0 = bytes[offset++])) {
            throw new IllegalStateException("Invalid leading byte: " + byte0);
        }
        int sign = NumberUtil.readSign(byte0);
        if (sign == 0) {
            return BigDecimal.ZERO;
        }
        ReadBuffer in = new ReadBuffer(bytes, offset);
        int exponent = NumberUtil.readExponent(in, byte0, sign);
        return NumberUtil.createNumericObject(in, sign, exponent);
    }

    private static byte[] writeBytes(int sign, int exponent, String digits) {
        return NumberUtil.writeBytes(sign, exponent, digits.toCharArray(), 0, digits.length());
    }

    private static byte[] writeBytes(int sign, int exponent, char[] digits, int from, int len) {
        int nLeadingBytes = NumberUtil.getNumBytesExponent(sign, exponent);
        int size = nLeadingBytes + (len + 1) / 2 + 1;
        byte[] bytes = new byte[size];
        NumberUtil.writeExponent(bytes, 0, sign, exponent);
        NumberUtil.writeMantissa(bytes, nLeadingBytes, sign, digits, from, len);
        return bytes;
    }

    private static void writeExponent(byte[] buffer, int offset, int sign, int value) {
        if (sign == 0) {
            buffer[offset] = -128;
        } else if (sign > 0) {
            if (value >= 4097) {
                NumberUtil.writeExponentMultiBytes(buffer, offset, (byte)-9, value - 4097);
            } else if (value >= 64) {
                NumberUtil.writeExponentTwoBytes(buffer, offset, (byte)-25, value - 64);
            } else if (value >= -16) {
                buffer[offset] = (byte)(151 + (value - -16));
            } else if (value >= -4096) {
                NumberUtil.writeExponentTwoBytes(buffer, offset, (byte)-121, value - -4096);
            } else {
                NumberUtil.writeExponentMultiBytes(buffer, offset, (byte)-125, value - Integer.MIN_VALUE);
            }
        } else if (value <= -4097) {
            NumberUtil.writeExponentMultiBytes(buffer, offset, (byte)122, -4097 - value);
        } else if (value <= -17) {
            NumberUtil.writeExponentTwoBytes(buffer, offset, (byte)106, -17 - value);
        } else if (value <= 63) {
            buffer[offset] = (byte)(26 + (63 - value));
        } else if (value <= 4096) {
            NumberUtil.writeExponentTwoBytes(buffer, offset, (byte)10, 4096 - value);
        } else {
            NumberUtil.writeExponentMultiBytes(buffer, offset, (byte)6, Integer.MAX_VALUE - value);
        }
    }

    private static void writeExponentTwoBytes(byte[] buffer, int offset, byte byte0, int exponent) {
        buffer[offset++] = (byte)(byte0 + (exponent >> 8 & 0xF));
        buffer[offset] = (byte)(exponent & 0xFF);
    }

    private static void writeExponentMultiBytes(byte[] buffer, int offset, byte byte0, int exponent) {
        int size = NumberUtil.getNumBytesExponentVarLen(exponent);
        buffer[offset++] = (byte)(byte0 + (size - 2));
        if (size > 4) {
            buffer[offset++] = (byte)(exponent >>> 24);
        }
        if (size > 3) {
            buffer[offset++] = (byte)(exponent >>> 16);
        }
        if (size > 2) {
            buffer[offset++] = (byte)(exponent >>> 8);
        }
        buffer[offset] = (byte)exponent;
    }

    private static int getNumBytesExponent(int sign, int value) {
        if (sign == 0) {
            return 1;
        }
        if (sign > 0) {
            if (value >= 4097) {
                return NumberUtil.getNumBytesExponentVarLen(value - 4097);
            }
            if (value >= 64) {
                return 2;
            }
            if (value >= -16) {
                return 1;
            }
            if (value >= -4096) {
                return 2;
            }
            return NumberUtil.getNumBytesExponentVarLen(value - Integer.MIN_VALUE);
        }
        if (value <= -4097) {
            return NumberUtil.getNumBytesExponentVarLen(-4097 - value);
        }
        if (value <= -17) {
            return 2;
        }
        if (value <= 63) {
            return 1;
        }
        if (value <= 4096) {
            return 2;
        }
        return NumberUtil.getNumBytesExponentVarLen(Integer.MAX_VALUE - value);
    }

    private static int getNumBytesExponentVarLen(int exponent) {
        if ((exponent & 0xFF000000) != 0) {
            return 5;
        }
        if ((exponent & 0xFF0000) != 0) {
            return 4;
        }
        if ((exponent & 0xFF00) != 0) {
            return 3;
        }
        return 2;
    }

    private static void writeMantissa(byte[] buffer, int offset, int sign, char[] digits, int start, int len) {
        for (int ind = 0; ind < len / 2; ++ind) {
            NumberUtil.writeByte(buffer, offset++, sign, digits, start + ind * 2);
        }
        if (len % 2 == 1) {
            int last = start + len - 1;
            NumberUtil.writeByte(buffer, offset++, sign, new char[]{digits[last], '0'}, 0);
        }
        buffer[offset] = NumberUtil.excess128(-1);
    }

    private static void writeByte(byte[] buffer, int offset, int sign, char[] digits, int index) {
        if (digits.length <= index + 1) {
            throw new IllegalArgumentException("Invalid digits buffer with length  " + digits.length + ", it should be greater than " + (index + 1));
        }
        int value = (digits[index] - 48) * 10 + (digits[index + 1] - 48);
        if (sign < 0) {
            value = -1 * value;
        }
        buffer[offset] = NumberUtil.toUnsignedByte(value);
    }

    private static byte toUnsignedByte(int value) {
        if (value < 0) {
            value -= 2;
        }
        return NumberUtil.excess128(value);
    }

    private static int readExponent(ReadBuffer in, byte byte0, int sign) {
        if (sign == 0) {
            return 0;
        }
        if (sign > 0) {
            if (byte0 >= -9) {
                return NumberUtil.readExponentMultiBytes(in, byte0, (byte)-9) + 4097;
            }
            if (byte0 >= -25) {
                return NumberUtil.readExponentTwoBytes(in, byte0, (byte)-25) + 64;
            }
            if (byte0 >= -105) {
                return byte0 - -105 + -16;
            }
            if (byte0 >= -121) {
                return NumberUtil.readExponentTwoBytes(in, byte0, (byte)-121) + -4096;
            }
            return NumberUtil.readExponentMultiBytes(in, byte0, (byte)-125) + Integer.MIN_VALUE;
        }
        if (byte0 >= 122) {
            return -4097 - NumberUtil.readExponentMultiBytes(in, byte0, (byte)122);
        }
        if (byte0 >= 106) {
            return -17 - NumberUtil.readExponentTwoBytes(in, byte0, (byte)106);
        }
        if (byte0 >= 26) {
            return 63 - (byte0 - 26);
        }
        if (byte0 >= 10) {
            return 4096 - NumberUtil.readExponentTwoBytes(in, byte0, (byte)10);
        }
        return Integer.MAX_VALUE - NumberUtil.readExponentMultiBytes(in, byte0, (byte)6);
    }

    private static boolean isValidLeadingByte(byte byte0) {
        return byte0 >= -125 && byte0 <= -6 || byte0 >= 6 && byte0 <= 125 || byte0 == -128 || byte0 == 0 || byte0 == -1;
    }

    private static int readExponentTwoBytes(ReadBuffer in, byte byte0, byte base) {
        return byte0 - base << 8 | in.read() & 0xFF;
    }

    private static int readExponentMultiBytes(ReadBuffer in, byte byte0, byte base) {
        int len = byte0 - base + 1;
        int exp = 0;
        while (len-- > 0) {
            exp = exp << 8 | in.read() & 0xFF;
        }
        return exp;
    }

    private static BigDecimal createNumericObject(ReadBuffer in, int sign, int expo) {
        int val;
        int size = (in.available() - 1) * 2;
        char[] buf = new char[size];
        int ind = 0;
        while ((val = NumberUtil.excess128(in.read())) != -1) {
            String group;
            if (val < 0) {
                val += 2;
            }
            if ((group = Integer.toString(Math.abs(val))).length() == 1) {
                buf[ind++] = 48;
                buf[ind++] = group.charAt(0);
                continue;
            }
            buf[ind++] = group.charAt(0);
            buf[ind++] = group.charAt(1);
        }
        if (buf[ind - 1] == '0') {
            --ind;
        }
        String digits = new String(buf, 0, ind);
        BigInteger unscaled = new BigInteger(digits);
        if (sign < 0) {
            unscaled = unscaled.negate();
        }
        return new BigDecimal(unscaled, digits.length() - 1).scaleByPowerOfTen(expo);
    }

    private static int readSign(byte byte0) {
        return byte0 == -128 ? 0 : ((byte0 & 0x80) > 0 ? 1 : -1);
    }

    private static byte excess128(int b) {
        return (byte)(b ^ 0x80);
    }

    private static class ReadBuffer {
        private final byte[] bytes;
        private int offset;

        ReadBuffer(byte[] bytes, int offset) {
            this.bytes = bytes;
            this.offset = offset;
        }

        byte read() {
            if (this.offset < this.bytes.length) {
                return this.bytes[this.offset++];
            }
            return -1;
        }

        int available() {
            return this.bytes.length - this.offset;
        }
    }
}

