/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.query;

import oracle.nosql.driver.query.PlanIter;
import oracle.nosql.driver.query.QueryStateException;

public class PlanIterState {
    private StateEnum theState = StateEnum.OPEN;

    public boolean isOpen() {
        return this.theState == StateEnum.OPEN;
    }

    boolean isClosed() {
        return this.theState == StateEnum.CLOSED;
    }

    public boolean isDone() {
        return this.theState == StateEnum.DONE;
    }

    public void reset(PlanIter iter) {
        this.setState(StateEnum.OPEN);
    }

    public void close() {
        this.setState(StateEnum.CLOSED);
    }

    public void done() {
        this.setState(StateEnum.DONE);
    }

    public void setState(StateEnum v) {
        switch (this.theState) {
            case RUNNING: {
                if (v != StateEnum.RUNNING && v != StateEnum.DONE && v != StateEnum.CLOSED && v != StateEnum.OPEN) break;
                this.theState = v;
                return;
            }
            case DONE: {
                if (v != StateEnum.OPEN && v != StateEnum.CLOSED) break;
                this.theState = v;
                return;
            }
            case OPEN: {
                if (v != StateEnum.OPEN && v != StateEnum.RUNNING && v != StateEnum.CLOSED && v != StateEnum.DONE) break;
                this.theState = v;
                return;
            }
        }
        throw new QueryStateException("Wrong state transition for iterator " + this.getClass() + ". Current state: " + (Object)((Object)this.theState) + " New state: " + (Object)((Object)v));
    }

    public static enum StateEnum {
        OPEN,
        RUNNING,
        DONE,
        CLOSED;

    }
}

