/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.query;

import java.io.IOException;
import java.math.BigDecimal;
import oracle.nosql.driver.query.AggrIterState;
import oracle.nosql.driver.query.PlanIter;
import oracle.nosql.driver.query.PlanIterState;
import oracle.nosql.driver.query.QueryFormatter;
import oracle.nosql.driver.query.QueryStateException;
import oracle.nosql.driver.query.RuntimeControlBlock;
import oracle.nosql.driver.util.ByteInputStream;
import oracle.nosql.driver.values.DoubleValue;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.IntegerValue;
import oracle.nosql.driver.values.LongValue;
import oracle.nosql.driver.values.NullValue;
import oracle.nosql.driver.values.NumberValue;

public class FuncSumIter
extends PlanIter {
    private final PlanIter theInput;

    FuncSumIter(ByteInputStream in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theInput = FuncSumIter.deserializeIter(in, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.FN_SUM;
    }

    @Override
    PlanIter getInputIter() {
        return this.theInput;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new AggrIterState());
        this.theInput.open(rcb);
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInput.reset(rcb);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInput.close(rcb);
        state.close();
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        AggrIterState state = (AggrIterState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        boolean more;
        while (more = this.theInput.next(rcb)) {
            FieldValue val = rcb.getRegVal(this.theInput.getResultReg());
            if (rcb.getTraceLevel() >= 2) {
                rcb.trace("Summing up value " + val);
            }
            if (val.isNull()) continue;
            state.theNullInputOnly = false;
            FuncSumIter.sumNewValue(state, val);
        }
        return true;
    }

    static void sumNewValue(AggrIterState state, FieldValue val) {
        block0 : switch (val.getType()) {
            case INTEGER: {
                ++state.theCount;
                switch (state.theSumType) {
                    case LONG: {
                        state.theLongSum += (long)((IntegerValue)val).getValue();
                        break block0;
                    }
                    case DOUBLE: {
                        state.theDoubleSum += (double)((IntegerValue)val).getValue();
                        break block0;
                    }
                    case NUMBER: {
                        BigDecimal bd = new BigDecimal(((IntegerValue)val).getValue());
                        state.theNumberSum = state.theNumberSum.add(bd);
                        break block0;
                    }
                }
                assert (false);
                break;
            }
            case LONG: {
                ++state.theCount;
                switch (state.theSumType) {
                    case LONG: {
                        state.theLongSum += ((LongValue)val).getValue();
                        break block0;
                    }
                    case DOUBLE: {
                        state.theDoubleSum += (double)((LongValue)val).getValue();
                        break block0;
                    }
                    case NUMBER: {
                        BigDecimal bd = new BigDecimal(((LongValue)val).getValue());
                        state.theNumberSum = state.theNumberSum.add(bd);
                        break block0;
                    }
                }
                assert (false);
                break;
            }
            case DOUBLE: {
                ++state.theCount;
                switch (state.theSumType) {
                    case LONG: {
                        state.theDoubleSum = state.theLongSum;
                        state.theDoubleSum += ((DoubleValue)val).getValue();
                        state.theSumType = FieldValue.Type.DOUBLE;
                        break block0;
                    }
                    case DOUBLE: {
                        state.theDoubleSum += ((DoubleValue)val).getValue();
                        break block0;
                    }
                    case NUMBER: {
                        BigDecimal bd = new BigDecimal(((DoubleValue)val).getValue());
                        state.theNumberSum = state.theNumberSum.add(bd);
                        break block0;
                    }
                }
                assert (false);
                break;
            }
            case NUMBER: {
                ++state.theCount;
                if (state.theNumberSum == null) {
                    state.theNumberSum = new BigDecimal(0);
                }
                switch (state.theSumType) {
                    case LONG: {
                        state.theNumberSum = new BigDecimal(state.theLongSum);
                        state.theNumberSum = state.theNumberSum.add(((NumberValue)val).getValue());
                        state.theSumType = FieldValue.Type.NUMBER;
                        break block0;
                    }
                    case DOUBLE: {
                        state.theNumberSum = new BigDecimal(state.theDoubleSum);
                        state.theNumberSum = state.theNumberSum.add(((NumberValue)val).getValue());
                        state.theSumType = FieldValue.Type.NUMBER;
                        break block0;
                    }
                    case NUMBER: {
                        state.theNumberSum = state.theNumberSum.add(((NumberValue)val).getValue());
                        break block0;
                    }
                }
                assert (false);
                break;
            }
        }
    }

    @Override
    FieldValue getAggrValue(RuntimeControlBlock rcb, boolean reset) {
        AggrIterState state = (AggrIterState)rcb.getState(this.theStatePos);
        FieldValue res = null;
        if (state.theNullInputOnly) {
            return NullValue.getInstance();
        }
        switch (state.theSumType) {
            case LONG: {
                res = new LongValue(state.theLongSum);
                break;
            }
            case DOUBLE: {
                res = new DoubleValue(state.theDoubleSum);
                break;
            }
            case NUMBER: {
                res = new NumberValue(state.theNumberSum);
                break;
            }
            default: {
                throw new QueryStateException("Unexpected result type for SUM function: " + (Object)((Object)state.theSumType));
            }
        }
        if (rcb.getTraceLevel() >= 4) {
            rcb.trace("Computed sum = " + res);
        }
        if (reset) {
            state.reset(this);
        }
        return res;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInput.display(sb, formatter);
    }
}

