/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import oracle.nosql.driver.NoSQLException;
import oracle.nosql.driver.NoSQLHandle;
import oracle.nosql.driver.RequestTimeoutException;
import oracle.nosql.driver.ops.GetTableRequest;
import oracle.nosql.driver.ops.Result;
import oracle.nosql.driver.ops.TableLimits;

public class TableResult
extends Result {
    private String domainId;
    private String tableName;
    private State state;
    private TableLimits limits;
    private String schema;
    private String operationId;

    public State getTableState() {
        return this.state;
    }

    public String getCompartmentId() {
        return this.domainId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchema() {
        return this.schema;
    }

    public TableLimits getTableLimits() {
        return this.limits;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public TableResult setOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public TableResult setState(State state) {
        this.state = state;
        return this;
    }

    public TableResult setDomainId(String domainId) {
        this.domainId = domainId;
        return this;
    }

    public TableResult setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public TableResult setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public TableResult setTableLimits(TableLimits limits) {
        this.limits = limits;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("table ");
        sb.append(this.tableName).append("[").append((Object)this.state).append("] ").append(this.limits).append(" schema [" + this.schema + "]").append(" operationId = ").append(this.operationId);
        return sb.toString();
    }

    @Deprecated
    public static TableResult waitForState(NoSQLHandle handle, TableResult result, State state, int waitMillis, int delayMillis) {
        return TableResult.waitForState(handle, result.getTableName(), result.getCompartmentId(), result.getOperationId(), state, waitMillis, delayMillis);
    }

    @Deprecated
    public static TableResult waitForState(NoSQLHandle handle, String tableName, State state, int waitMillis, int delayMillis) {
        return TableResult.waitForState(handle, tableName, null, null, state, waitMillis, delayMillis);
    }

    @Deprecated
    public static TableResult waitForState(NoSQLHandle handle, String tableName, String operationId, State state, int waitMillis, int delayMillis) {
        return TableResult.waitForState(handle, tableName, null, operationId, state, waitMillis, delayMillis);
    }

    private static TableResult waitForState(NoSQLHandle handle, String tableName, String compartment, String operationId, State state, int waitMillis, int delayMillis) {
        int delayMS;
        int DELAY_MS = 500;
        int n = delayMS = delayMillis != 0 ? delayMillis : 500;
        if (waitMillis < delayMillis) {
            throw new IllegalArgumentException("Wait milliseconds must be a mininum of 500 and greater than delay milliseconds");
        }
        long startTime = System.currentTimeMillis();
        GetTableRequest getTable = new GetTableRequest().setTableName(tableName).setOperationId(operationId).setCompartment(compartment);
        TableResult res = null;
        do {
            long curTime;
            if ((curTime = System.currentTimeMillis()) - startTime > (long)waitMillis) {
                throw new RequestTimeoutException(waitMillis, "Expected table state (" + (Object)((Object)state) + ") for table " + tableName + " not reached ");
            }
            try {
                if (res != null) {
                    Thread.sleep(delayMS);
                }
                res = handle.getTable(getTable);
            }
            catch (InterruptedException ie) {
                throw new NoSQLException("waitForState interrupted: " + ie.getMessage());
            }
        } while (!res.getTableState().equals((Object)state));
        return res;
    }

    public void waitForCompletion(NoSQLHandle handle, int waitMillis, int delayMillis) {
        int delayMS;
        if (this.isTerminal()) {
            return;
        }
        if (this.operationId == null) {
            throw new IllegalArgumentException("Operation state must not be null");
        }
        int DELAY_MS = 500;
        int n = delayMS = delayMillis != 0 ? delayMillis : 500;
        if (waitMillis < delayMillis) {
            throw new IllegalArgumentException("Wait milliseconds must be a mininum of 500 and greater than delay milliseconds");
        }
        long startTime = System.currentTimeMillis();
        GetTableRequest getTable = new GetTableRequest().setTableName(this.tableName).setOperationId(this.operationId).setCompartment(this.domainId);
        TableResult res = null;
        while (!this.isTerminal()) {
            long curTime = System.currentTimeMillis();
            if (curTime - startTime > (long)waitMillis) {
                throw new RequestTimeoutException(waitMillis, "Operation not completed in expected time");
            }
            try {
                if (res != null) {
                    Thread.sleep(delayMS);
                }
                res = handle.getTable(getTable);
                this.state = res.getTableState();
                this.limits = res.getTableLimits();
                this.schema = res.getSchema();
            }
            catch (InterruptedException ie) {
                throw new NoSQLException("waitForCompletion interrupted: " + ie.getMessage());
            }
        }
    }

    private boolean isTerminal() {
        return this.state == State.ACTIVE || this.state == State.DROPPED;
    }

    public static enum State {
        ACTIVE,
        CREATING,
        DROPPED,
        DROPPING,
        UPDATING;

    }
}

