/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.values;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;
import oracle.nosql.driver.values.ArrayValue;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.MapValue;
import oracle.nosql.driver.values.TimestampValue;

public interface FieldValueEventHandler {
    public void startMap(int var1) throws IOException;

    public void startArray(int var1) throws IOException;

    public void endMap(int var1) throws IOException;

    public void endArray(int var1) throws IOException;

    public void startMapField(String var1) throws IOException;

    public void endMapField() throws IOException;

    public void endArrayField() throws IOException;

    public void booleanValue(boolean var1) throws IOException;

    public void binaryValue(byte[] var1) throws IOException;

    public void stringValue(String var1) throws IOException;

    public void integerValue(int var1) throws IOException;

    public void longValue(long var1) throws IOException;

    public void doubleValue(double var1) throws IOException;

    public void numberValue(BigDecimal var1) throws IOException;

    public void timestampValue(TimestampValue var1) throws IOException;

    public void jsonNullValue() throws IOException;

    public void nullValue() throws IOException;

    public void emptyValue() throws IOException;

    public static void generate(FieldValue value, FieldValueEventHandler handler) throws IOException {
        FieldValue.Type type = value.getType();
        switch (type) {
            case ARRAY: {
                FieldValueEventHandler.generateForArray(value.asArray(), handler);
                break;
            }
            case BINARY: {
                handler.binaryValue(value.getBinary());
                break;
            }
            case BOOLEAN: {
                handler.booleanValue(value.getBoolean());
                break;
            }
            case DOUBLE: {
                handler.doubleValue(value.getDouble());
                break;
            }
            case INTEGER: {
                handler.integerValue(value.getInt());
                break;
            }
            case LONG: {
                handler.longValue(value.getLong());
                break;
            }
            case MAP: {
                FieldValueEventHandler.generateForMap(value.asMap(), handler);
                break;
            }
            case STRING: {
                handler.stringValue(value.asString().getString());
                break;
            }
            case TIMESTAMP: {
                handler.timestampValue(value.asTimestamp());
                break;
            }
            case NUMBER: {
                handler.numberValue(value.asNumber().getValue());
                break;
            }
            case JSON_NULL: {
                handler.jsonNullValue();
                break;
            }
            case NULL: {
                handler.nullValue();
                break;
            }
            case EMPTY: {
                handler.emptyValue();
                break;
            }
            default: {
                throw new IllegalStateException("FieldValueEventHandler, unknown type " + (Object)((Object)type));
            }
        }
    }

    public static void generateForMap(MapValue map, FieldValueEventHandler handler) throws IOException {
        handler.startMap(map.size());
        for (Map.Entry<String, FieldValue> entry : map.entrySet()) {
            handler.startMapField(entry.getKey());
            FieldValueEventHandler.generate(entry.getValue(), handler);
            handler.endMapField();
        }
        handler.endMap(map.size());
    }

    public static void generateForArray(ArrayValue array, FieldValueEventHandler handler) throws IOException {
        handler.startArray(array.size());
        for (FieldValue value : array) {
            FieldValueEventHandler.generate(value, handler);
            handler.endArrayField();
        }
        handler.endArray(array.size());
    }
}

