/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.values;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Timestamp;
import oracle.nosql.driver.ops.serde.BinaryProtocol;
import oracle.nosql.driver.values.ArrayValue;
import oracle.nosql.driver.values.BinaryValue;
import oracle.nosql.driver.values.BooleanValue;
import oracle.nosql.driver.values.DoubleValue;
import oracle.nosql.driver.values.EmptyValue;
import oracle.nosql.driver.values.FieldValueEventHandler;
import oracle.nosql.driver.values.IntegerValue;
import oracle.nosql.driver.values.JsonNullValue;
import oracle.nosql.driver.values.JsonOptions;
import oracle.nosql.driver.values.JsonPrettySerializer;
import oracle.nosql.driver.values.JsonSerializer;
import oracle.nosql.driver.values.JsonUtils;
import oracle.nosql.driver.values.LongValue;
import oracle.nosql.driver.values.MapValue;
import oracle.nosql.driver.values.NullValue;
import oracle.nosql.driver.values.NumberValue;
import oracle.nosql.driver.values.StringValue;
import oracle.nosql.driver.values.TimestampValue;

public abstract class FieldValue
implements Comparable<FieldValue> {
    public abstract Type getType();

    public int getInt() {
        return this.asInteger().getValue();
    }

    public long getLong() {
        return this.asLong().getValue();
    }

    public double getDouble() {
        return this.asDouble().getValue();
    }

    public BigDecimal getNumber() {
        return this.asNumber().getValue();
    }

    public double castAsDouble() {
        throw new ClassCastException("Value can not be cast to a double: " + this.getClass());
    }

    public byte[] getBinary() {
        return this.asBinary().getValue();
    }

    public boolean getBoolean() {
        return this.asBoolean().getValue();
    }

    public String getString() {
        return this.asString().getValue();
    }

    public Timestamp getTimestamp() {
        return this.asTimestamp().getValue();
    }

    public IntegerValue asInteger() {
        return (IntegerValue)this;
    }

    public StringValue asString() {
        return (StringValue)this;
    }

    public LongValue asLong() {
        return (LongValue)this;
    }

    public NumberValue asNumber() {
        return (NumberValue)this;
    }

    public TimestampValue asTimestamp() {
        if (this.getType() == Type.TIMESTAMP) {
            return (TimestampValue)this;
        }
        if (this.getType() == Type.STRING) {
            return new TimestampValue(this.getString());
        }
        if (this.getType() == Type.INTEGER || this.getType() == Type.LONG) {
            return new TimestampValue(this.getLong());
        }
        throw new ClassCastException("Can't cast to a TimestampValue");
    }

    public BooleanValue asBoolean() {
        return (BooleanValue)this;
    }

    public ArrayValue asArray() {
        return (ArrayValue)this;
    }

    public BinaryValue asBinary() {
        return (BinaryValue)this;
    }

    public MapValue asMap() {
        return (MapValue)this;
    }

    public DoubleValue asDouble() {
        return (DoubleValue)this;
    }

    public JsonNullValue asJsonNull() {
        return (JsonNullValue)this;
    }

    public NullValue asNull() {
        return (NullValue)this;
    }

    public EmptyValue asEmpty() {
        return (EmptyValue)this;
    }

    public boolean isInteger() {
        return this.getType() == Type.INTEGER;
    }

    public boolean isLong() {
        return this.getType() == Type.LONG;
    }

    public boolean isDouble() {
        return this.getType() == Type.DOUBLE;
    }

    public boolean isNumber() {
        return this.getType() == Type.NUMBER;
    }

    public boolean isBinary() {
        return this.getType() == Type.BINARY;
    }

    public boolean isBoolean() {
        return this.getType() == Type.BOOLEAN;
    }

    public boolean isArray() {
        return this.getType() == Type.ARRAY;
    }

    public boolean isMap() {
        return this.getType() == Type.MAP;
    }

    public boolean isString() {
        return this.getType() == Type.STRING;
    }

    public boolean isTimestamp() {
        return this.getType() == Type.TIMESTAMP;
    }

    public boolean isAtomic() {
        Type t = this.getType();
        return t != Type.ARRAY && t != Type.MAP;
    }

    public boolean isNumeric() {
        Type t = this.getType();
        switch (t) {
            case INTEGER: 
            case LONG: 
            case DOUBLE: 
            case NUMBER: {
                return true;
            }
        }
        return false;
    }

    public boolean isNull() {
        return this == NullValue.getInstance();
    }

    public boolean isJsonNull() {
        return this == JsonNullValue.getInstance();
    }

    public boolean isAnyNull() {
        return this.isJsonNull() || this.isNull();
    }

    public boolean isEMPTY() {
        return this == EmptyValue.getInstance();
    }

    public String toJson() {
        return this.toJson(null);
    }

    public String toJson(JsonOptions options) {
        JsonSerializer handler = options != null && options.getPrettyPrint() ? new JsonPrettySerializer(options) : new JsonSerializer(options);
        try {
            FieldValueEventHandler.generate(this, handler);
            return ((Object)handler).toString();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to serialize FieldValue into JSON: " + ioe.getMessage());
        }
    }

    public String toString() {
        return this.toJson();
    }

    public int getSerializedSize() {
        return BinaryProtocol.getSerializedSize(this);
    }

    public abstract long sizeof();

    public static FieldValue createFromJson(String jsonInput, JsonOptions options) {
        return JsonUtils.createValueFromJson(jsonInput, options);
    }

    public static FieldValue createFromJson(Reader jsonInput, JsonOptions options) {
        return JsonUtils.createValueFromJson(jsonInput, options);
    }

    public static FieldValue createFromJson(InputStream jsonInput, JsonOptions options) {
        return JsonUtils.createValueFromJson(jsonInput, options);
    }

    static void validateName(String name, FieldValue value) {
        if (name == null) {
            throw new IllegalArgumentException("Field name is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("FieldValue is null");
        }
    }

    public static enum Type {
        ARRAY,
        BINARY,
        BOOLEAN,
        DOUBLE,
        INTEGER,
        LONG,
        MAP,
        STRING,
        TIMESTAMP,
        NUMBER,
        JSON_NULL,
        NULL,
        EMPTY;

    }
}

