/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.nosql.driver.RateLimiter;
import oracle.nosql.driver.util.SimpleRateLimiter;

public class RateLimiterMap {
    private final Map<String, Entry> limiterMap = new ConcurrentHashMap<String, Entry>();

    public synchronized void update(String tableName, double readUnits, double writeUnits, double durationSeconds) {
        if (readUnits <= 0.0 && writeUnits <= 0.0) {
            this.remove(tableName);
            return;
        }
        String lowerTable = tableName.toLowerCase();
        Entry rle = this.limiterMap.get(lowerTable);
        if (rle == null) {
            SimpleRateLimiter rrl = new SimpleRateLimiter(readUnits, durationSeconds);
            SimpleRateLimiter wrl = new SimpleRateLimiter(writeUnits, durationSeconds);
            this.limiterMap.put(lowerTable, new Entry(rrl, wrl));
        } else {
            double prevRUs = rle.readLimiter.getLimitPerSecond();
            double prevWUs = rle.writeLimiter.getLimitPerSecond();
            rle.readLimiter.setLimitPerSecond(readUnits);
            rle.writeLimiter.setLimitPerSecond(writeUnits);
            if (rle.readLimiter.getLimitPerSecond() != prevRUs) {
                rle.readLimiter.reset();
            }
            if (rle.writeLimiter.getLimitPerSecond() != prevWUs) {
                rle.writeLimiter.reset();
            }
        }
    }

    public void remove(String tableName) {
        this.limiterMap.remove(tableName.toLowerCase());
    }

    public RateLimiter getReadLimiter(String tableName) {
        Entry rle = this.limiterMap.get(tableName.toLowerCase());
        if (rle == null) {
            return null;
        }
        return rle.readLimiter;
    }

    public RateLimiter getWriteLimiter(String tableName) {
        Entry rle = this.limiterMap.get(tableName.toLowerCase());
        if (rle == null) {
            return null;
        }
        return rle.writeLimiter;
    }

    public boolean limitersExist(String tableName) {
        return this.limiterMap.get(tableName.toLowerCase()) != null;
    }

    public void clear() {
        this.limiterMap.clear();
    }

    public synchronized void reset(String tableName) {
        String lowerTable = tableName.toLowerCase();
        Entry rle = this.limiterMap.get(lowerTable);
        if (rle != null) {
            rle.readLimiter.reset();
            rle.writeLimiter.reset();
        }
    }

    public class Entry {
        RateLimiter readLimiter;
        RateLimiter writeLimiter;

        private Entry(RateLimiter readLimiter, RateLimiter writeLimiter) {
            this.readLimiter = readLimiter;
            this.writeLimiter = writeLimiter;
        }
    }
}

