/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.values;

import java.math.BigDecimal;
import oracle.nosql.driver.util.SizeOf;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.JsonOptions;

public class IntegerValue
extends FieldValue {
    private final int value;

    public IntegerValue(int value) {
        this.value = value;
    }

    @Override
    public FieldValue.Type getType() {
        return FieldValue.Type.INTEGER;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public int compareTo(FieldValue other) {
        return Integer.compare(this.value, other.getInt());
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public double castAsDouble() {
        return this.value;
    }

    @Override
    public BigDecimal getNumber() {
        return new BigDecimal(this.value);
    }

    @Override
    public String toJson(JsonOptions options) {
        return String.valueOf(this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof IntegerValue) {
            return this.value == ((IntegerValue)other).value;
        }
        return false;
    }

    public int hashCode() {
        return Integer.valueOf(this.value).hashCode();
    }

    @Override
    public long sizeof() {
        return SizeOf.OBJECT_OVERHEAD + 4;
    }
}

