/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.util;

class PackedInteger {
    public static final int MAX_LENGTH = 5;
    public static final int MAX_LONG_LENGTH = 9;

    PackedInteger() {
    }

    public static int readSortedInt(byte[] buf, int off) {
        boolean negative;
        int byteLen;
        int b1;
        if ((b1 = buf[off++] & 0xFF) < 8) {
            byteLen = 8 - b1;
            negative = true;
        } else if (b1 > 247) {
            byteLen = b1 - 247;
            negative = false;
        } else {
            return b1 - 127;
        }
        int value = negative ? -1 : 0;
        if (byteLen > 3) {
            value = value << 8 | buf[off++] & 0xFF;
        }
        if (byteLen > 2) {
            value = value << 8 | buf[off++] & 0xFF;
        }
        if (byteLen > 1) {
            value = value << 8 | buf[off++] & 0xFF;
        }
        value = value << 8 | buf[off++] & 0xFF;
        value = negative ? (value -= 119) : (value += 121);
        return value;
    }

    public static long readSortedLong(byte[] buf, int off) {
        boolean negative;
        int byteLen;
        int b1;
        if ((b1 = buf[off++] & 0xFF) < 8) {
            byteLen = 8 - b1;
            negative = true;
        } else if (b1 > 247) {
            byteLen = b1 - 247;
            negative = false;
        } else {
            return b1 - 127;
        }
        long value = negative ? -1L : 0L;
        if (byteLen > 7) {
            value = value << 8 | (long)(buf[off++] & 0xFF);
        }
        if (byteLen > 6) {
            value = value << 8 | (long)(buf[off++] & 0xFF);
        }
        if (byteLen > 5) {
            value = value << 8 | (long)(buf[off++] & 0xFF);
        }
        if (byteLen > 4) {
            value = value << 8 | (long)(buf[off++] & 0xFF);
        }
        if (byteLen > 3) {
            value = value << 8 | (long)(buf[off++] & 0xFF);
        }
        if (byteLen > 2) {
            value = value << 8 | (long)(buf[off++] & 0xFF);
        }
        if (byteLen > 1) {
            value = value << 8 | (long)(buf[off++] & 0xFF);
        }
        value = value << 8 | (long)(buf[off++] & 0xFF);
        value = negative ? (value -= 119L) : (value += 121L);
        return value;
    }

    public static int getReadSortedIntLength(byte[] buf, int off) {
        int b1 = buf[off] & 0xFF;
        if (b1 < 8) {
            return 9 - b1;
        }
        if (b1 > 247) {
            return 1 + b1 - 247;
        }
        return 1;
    }

    public static int getReadSortedLongLength(byte[] buf, int off) {
        return PackedInteger.getReadSortedIntLength(buf, off);
    }

    public static int writeSortedInt(byte[] buf, int offset, int value) {
        int byte1Off = offset++;
        if (value < -119) {
            if (((value += 119) | 0xFFFFFF) != -1) {
                buf[offset++] = (byte)(value >> 24);
            }
            if ((value | 0xFFFF) != -1) {
                buf[offset++] = (byte)(value >> 16);
            }
            if ((value | 0xFF) != -1) {
                buf[offset++] = (byte)(value >> 8);
            }
            buf[offset++] = (byte)value;
            int valueLen = offset - byte1Off - 1;
            buf[byte1Off] = (byte)(8 - valueLen);
        } else if (value > 120) {
            if (((value -= 121) & 0xFF000000) != 0) {
                buf[offset++] = (byte)(value >> 24);
            }
            if ((value & 0xFFFF0000) != 0) {
                buf[offset++] = (byte)(value >> 16);
            }
            if ((value & 0xFFFFFF00) != 0) {
                buf[offset++] = (byte)(value >> 8);
            }
            buf[offset++] = (byte)value;
            int valueLen = offset - byte1Off - 1;
            buf[byte1Off] = (byte)(247 + valueLen);
        } else {
            buf[byte1Off] = (byte)(value + 127);
        }
        return offset;
    }

    public static int writeSortedLong(byte[] buf, int offset, long value) {
        int byte1Off = offset++;
        if (value < -119L) {
            if (((value += 119L) | 0xFFFFFFFFFFFFFFL) != -1L) {
                buf[offset++] = (byte)(value >> 56);
            }
            if ((value | 0xFFFFFFFFFFFFL) != -1L) {
                buf[offset++] = (byte)(value >> 48);
            }
            if ((value | 0xFFFFFFFFFFL) != -1L) {
                buf[offset++] = (byte)(value >> 40);
            }
            if ((value | 0xFFFFFFFFL) != -1L) {
                buf[offset++] = (byte)(value >> 32);
            }
            if ((value | 0xFFFFFFL) != -1L) {
                buf[offset++] = (byte)(value >> 24);
            }
            if ((value | 0xFFFFL) != -1L) {
                buf[offset++] = (byte)(value >> 16);
            }
            if ((value | 0xFFL) != -1L) {
                buf[offset++] = (byte)(value >> 8);
            }
            buf[offset++] = (byte)value;
            int valueLen = offset - byte1Off - 1;
            buf[byte1Off] = (byte)(8 - valueLen);
        } else if (value > 120L) {
            if (((value -= 121L) & 0xFF00000000000000L) != 0L) {
                buf[offset++] = (byte)(value >> 56);
            }
            if ((value & 0xFFFF000000000000L) != 0L) {
                buf[offset++] = (byte)(value >> 48);
            }
            if ((value & 0xFFFFFF0000000000L) != 0L) {
                buf[offset++] = (byte)(value >> 40);
            }
            if ((value & 0xFFFFFFFF00000000L) != 0L) {
                buf[offset++] = (byte)(value >> 32);
            }
            if ((value & 0xFFFFFFFFFF000000L) != 0L) {
                buf[offset++] = (byte)(value >> 24);
            }
            if ((value & 0xFFFFFFFFFFFF0000L) != 0L) {
                buf[offset++] = (byte)(value >> 16);
            }
            if ((value & 0xFFFFFFFFFFFFFF00L) != 0L) {
                buf[offset++] = (byte)(value >> 8);
            }
            buf[offset++] = (byte)value;
            int valueLen = offset - byte1Off - 1;
            buf[byte1Off] = (byte)(247 + valueLen);
        } else {
            buf[byte1Off] = (byte)(value + 127L);
        }
        return offset;
    }

    public static int getWriteSortedIntLength(int value) {
        if (value < -119) {
            if (((value += 119) | 0xFF) == -1) {
                return 2;
            }
            if ((value | 0xFFFF) == -1) {
                return 3;
            }
            if ((value | 0xFFFFFF) == -1) {
                return 4;
            }
        } else if (value > 120) {
            if (((value -= 121) & 0xFFFFFF00) == 0) {
                return 2;
            }
            if ((value & 0xFFFF0000) == 0) {
                return 3;
            }
            if ((value & 0xFF000000) == 0) {
                return 4;
            }
        } else {
            return 1;
        }
        return 5;
    }

    public static int getWriteSortedLongLength(long value) {
        if (value < -119L) {
            if (((value += 119L) | 0xFFL) == -1L) {
                return 2;
            }
            if ((value | 0xFFFFL) == -1L) {
                return 3;
            }
            if ((value | 0xFFFFFFL) == -1L) {
                return 4;
            }
            if ((value | 0xFFFFFFFFL) == -1L) {
                return 5;
            }
            if ((value | 0xFFFFFFFFFFL) == -1L) {
                return 6;
            }
            if ((value | 0xFFFFFFFFFFFFL) == -1L) {
                return 7;
            }
            if ((value | 0xFFFFFFFFFFFFFFL) == -1L) {
                return 8;
            }
        } else if (value > 120L) {
            if (((value -= 121L) & 0xFFFFFFFFFFFFFF00L) == 0L) {
                return 2;
            }
            if ((value & 0xFFFFFFFFFFFF0000L) == 0L) {
                return 3;
            }
            if ((value & 0xFFFFFFFFFF000000L) == 0L) {
                return 4;
            }
            if ((value & 0xFFFFFFFF00000000L) == 0L) {
                return 5;
            }
            if ((value & 0xFFFFFF0000000000L) == 0L) {
                return 6;
            }
            if ((value & 0xFFFF000000000000L) == 0L) {
                return 7;
            }
            if ((value & 0xFF00000000000000L) == 0L) {
                return 8;
            }
        } else {
            return 1;
        }
        return 9;
    }
}

