/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class LruCache<K, V> {
    private static final float LOAD_FACTOR = 0.6f;
    private static final int EVICTION_PERIOD_FACTOR = 10;
    private final int capacity;
    private volatile int lifetime;
    private final LinkedHashMap<K, CacheEntry<V>> cacheMap;
    private TimeBasedCleanupTask cleanupTask;
    private final ReentrantLock lock = new ReentrantLock();

    public LruCache(final int capacity, int lifetimeMs) {
        this.capacity = capacity;
        this.lifetime = lifetimeMs;
        this.cacheMap = capacity > 0 ? new LinkedHashMap<K, CacheEntry<V>>(capacity, 0.6f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, CacheEntry<V>> entry) {
                return this.size() > capacity;
            }
        } : new LinkedHashMap();
        if (this.lifetime > 0) {
            long evictionPeriodMs = this.lifetime * 10;
            this.cleanupTask = new TimeBasedCleanupTask(evictionPeriodMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        this.lock.lock();
        try {
            CacheEntry<V> entry = this.cacheMap.get(key);
            if (entry == null) {
                V v = null;
                return v;
            }
            if (this.isExpired(entry)) {
                this.cacheMap.remove(key);
                V v = null;
                return v;
            }
            Object object = ((CacheEntry)entry).getValue();
            return (V)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value) {
        this.lock.lock();
        try {
            CacheEntry entry = this.cacheMap.put(key, new CacheEntry(value));
            if (entry != null) {
                Object object = entry.getValue();
                return (V)object;
            }
            V v = null;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        this.lock.lock();
        try {
            CacheEntry entry = (CacheEntry)this.cacheMap.remove(key);
            if (entry != null) {
                Object object = entry.getValue();
                return (V)object;
            }
            V v = null;
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCreationTime(K key) {
        this.lock.lock();
        try {
            CacheEntry<V> entry = this.cacheMap.get(key);
            if (entry != null) {
                long l = entry.getCreateTime();
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<V> getAllValues() {
        this.lock.lock();
        try {
            HashSet<Object> copy = new HashSet<Object>();
            for (CacheEntry<V> entry : this.cacheMap.values()) {
                copy.add(((CacheEntry)entry).getValue());
            }
            HashSet<Object> hashSet = copy;
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop(boolean wait) {
        if (this.cleanupTask != null) {
            this.cleanupTask.stop(wait);
        }
    }

    private boolean isExpired(CacheEntry<V> entry) {
        long now = System.currentTimeMillis();
        return this.lifetime > 0 && now > entry.getCreateTime() + (long)this.lifetime;
    }

    private class TimeBasedCleanupTask
    implements Runnable {
        private volatile boolean terminated = false;
        private final long cleanupPeriodMs;
        private final Thread cleanUpThread;

        TimeBasedCleanupTask(long cleanupPeriodMs) {
            this.cleanupPeriodMs = cleanupPeriodMs;
            this.cleanUpThread = new Thread((Runnable)this, "CacheCleanUpThread");
            this.cleanUpThread.setDaemon(true);
            this.cleanUpThread.start();
        }

        void stop(boolean wait) {
            this.terminated = true;
            this.cleanUpThread.interrupt();
            if (wait) {
                try {
                    this.cleanUpThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void run() {
            while (!this.terminated) {
                try {
                    Thread.sleep(this.cleanupPeriodMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.terminated) {
                    return;
                }
                this.cleanup();
            }
            return;
        }

        void cleanup() {
            if (!LruCache.this.lock.tryLock()) {
                return;
            }
            try {
                Iterator iter = LruCache.this.cacheMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    if (!LruCache.this.isExpired((CacheEntry)entry.getValue())) continue;
                    iter.remove();
                }
            }
            finally {
                LruCache.this.lock.unlock();
            }
        }
    }

    private static class CacheEntry<V> {
        private final long createTime;
        private final V value;

        private CacheEntry(V value) {
            this.value = value;
            this.createTime = System.currentTimeMillis();
        }

        public long getCreateTime() {
            return this.createTime;
        }

        private V getValue() {
            return this.value;
        }
    }
}

