/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.query;

public class QueryException
extends RuntimeException {
    static final long serialVersionUID = 1L;
    protected final Location location;

    public QueryException(String message, Throwable cause, Location location) {
        super(message, cause);
        this.location = location;
    }

    public QueryException(String message, Location location) {
        super(message);
        this.location = location;
    }

    public QueryException(Throwable cause, Location location) {
        super(cause);
        this.location = location;
    }

    public QueryException(Throwable cause) {
        super(cause);
        this.location = null;
    }

    public QueryException(String message) {
        super(message);
        this.location = null;
    }

    public Location getLocation() {
        return this.location;
    }

    public IllegalArgumentException getIllegalArgument() {
        return new IllegalArgumentException(this.toString());
    }

    @Override
    public String toString() {
        return "Error:" + (this.location == null ? "" : " at (" + this.location.startLine + ", " + this.location.startColumn + ")") + " " + this.getMessage();
    }

    public static class Location {
        private final int startLine;
        private final int startColumn;
        private final int endLine;
        private final int endColumn;

        public Location(int startLine, int startColumn, int endLine, int endColumn) {
            this.startLine = startLine;
            this.startColumn = startColumn;
            this.endLine = endLine;
            this.endColumn = endColumn;
            assert (startLine >= 0);
            assert (startColumn >= 0);
            assert (endLine >= 0);
            assert (endColumn >= 0);
        }

        public String toString() {
            return this.startLine + ":" + this.startColumn + "-" + this.endLine + ":" + this.endColumn;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public int getStartColumn() {
            return this.startColumn;
        }

        public int getEndLine() {
            return this.endLine;
        }

        public int getEndColumn() {
            return this.endColumn;
        }
    }
}

