/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.iam;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.util.Arrays;
import oracle.nosql.driver.iam.AuthenticationProfileProvider;
import oracle.nosql.driver.util.CheckNull;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.EncryptionException;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

class PrivateKeyProvider {
    private final JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
    private RSAPrivateKey key = null;

    PrivateKeyProvider(AuthenticationProfileProvider provider) {
        this(provider.getPrivateKey(), provider.getPassphraseCharacters());
    }

    PrivateKeyProvider(InputStream keyInputStream, char[] passphrase) {
        this.getKeyInternal(keyInputStream, passphrase);
    }

    RSAPrivateKey getKey() {
        return this.key;
    }

    void reload(InputStream keyInputStream, char[] passphrase) {
        this.getKeyInternal(keyInputStream, passphrase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getKeyInternal(InputStream keyInputStream, char[] passphrase) {
        PEMParser keyReader = null;
        try {
            PrivateKeyInfo keyInfo;
            keyReader = new PEMParser((Reader)new InputStreamReader(keyInputStream, StandardCharsets.UTF_8));
            Object object = null;
            try {
                object = keyReader.readObject();
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Error reading private key", ioe);
            }
            if (object instanceof PEMEncryptedKeyPair) {
                CheckNull.requireNonNull(passphrase, "The provided private key requires a passphrase");
                JcePEMDecryptorProviderBuilder decryptBuilder = new JcePEMDecryptorProviderBuilder();
                if (!PrivateKeyProvider.isProviderInstalled()) {
                    decryptBuilder.setProvider(PrivateKeyProvider.getBouncyCastleProvider());
                }
                PEMDecryptorProvider decProv = decryptBuilder.build(passphrase);
                try {
                    keyInfo = ((PEMEncryptedKeyPair)object).decryptKeyPair(decProv).getPrivateKeyInfo();
                }
                catch (EncryptionException ee) {
                    throw new IllegalArgumentException("The provided passphrase is incorrect.", ee);
                }
                catch (IOException ioe) {
                    throw new IllegalArgumentException("Error decrypting private key.", ioe);
                }
            } else if (object instanceof PrivateKeyInfo) {
                keyInfo = (PrivateKeyInfo)object;
            } else if (object instanceof PEMKeyPair) {
                keyInfo = ((PEMKeyPair)object).getPrivateKeyInfo();
            } else {
                if (object instanceof SubjectPublicKeyInfo) {
                    throw new IllegalArgumentException("Public key provided instead of private key");
                }
                if (object != null) {
                    throw new IllegalArgumentException("Private key must be in PEM format,was: " + object.getClass());
                }
                throw new IllegalArgumentException("Private key must be in PEM format");
            }
            try {
                this.key = (RSAPrivateKey)this.converter.getPrivateKey(keyInfo);
            }
            catch (PEMException e) {
                throw new IllegalArgumentException("Error converting private key");
            }
        }
        finally {
            if (keyReader != null) {
                try {
                    keyReader.close();
                }
                catch (IOException iOException) {}
            }
            if (keyInputStream != null) {
                try {
                    keyInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (passphrase != null) {
                Arrays.fill(passphrase, ' ');
            }
        }
    }

    private static boolean isProviderInstalled() {
        return Security.getProvider("BC") != null;
    }

    private static Provider getBouncyCastleProvider() {
        Provider provider = null;
        try {
            Class<?> providerClass = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
            provider = (Provider)providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to find bouncy castle provider");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error creating bouncy castle provider");
        }
        return provider;
    }
}

