/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.httpclient;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import oracle.nosql.driver.httpclient.HttpClient;
import oracle.nosql.driver.httpclient.HttpClientHandler;
import oracle.nosql.driver.util.LogUtil;

@ChannelHandler.Sharable
public class HttpClientChannelPoolHandler
implements ChannelPoolHandler,
ChannelHealthChecker {
    private static final String CODEC_HANDLER_NAME = "http-codec";
    private static final String AGG_HANDLER_NAME = "http-aggregator";
    private static final String HTTP_HANDLER_NAME = "http-response-handler";
    private final HttpClient client;

    HttpClientChannelPoolHandler(HttpClient client) {
        this.client = client;
    }

    public void channelCreated(Channel ch) {
        LogUtil.logFine(this.client.getLogger(), "HttpClient " + this.client.getName() + ", channel created: " + ch);
        ChannelPipeline p = ch.pipeline();
        if (this.client.getSslContext() != null) {
            SslHandler sslHandler = this.client.getSslContext().newHandler(ch.alloc(), this.client.getHost(), this.client.getPort());
            SSLEngine sslEngine = sslHandler.engine();
            SSLParameters sslParameters = sslEngine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParameters);
            p.addLast(new ChannelHandler[]{sslHandler});
        }
        p.addLast(CODEC_HANDLER_NAME, (ChannelHandler)new HttpClientCodec(4096, 8192, this.client.getMaxChunkSize()));
        p.addLast(AGG_HANDLER_NAME, (ChannelHandler)new HttpObjectAggregator(this.client.getMaxContentLength()));
        p.addLast(HTTP_HANDLER_NAME, (ChannelHandler)new HttpClientHandler(this.client.getLogger()));
        if (this.client.getProxyHost() != null) {
            p.addFirst("proxyServer", (ChannelHandler)new HttpProxyHandler((SocketAddress)new InetSocketAddress(this.client.getProxyHost(), this.client.getProxyPort()), this.client.getProxyUsername(), this.client.getProxyPassword()));
        }
    }

    public void channelAcquired(Channel ch) {
    }

    public void channelReleased(Channel ch) {
    }

    public Future<Boolean> isHealthy(Channel channel) {
        boolean val = channel.isActive();
        if (!val) {
            LogUtil.logInfo(this.client.getLogger(), "HttpClient " + this.client.getName() + ", channel inactive in health check: " + channel);
        }
        EventLoop loop = channel.eventLoop();
        return val ? loop.newSucceededFuture((Object)Boolean.TRUE) : loop.newSucceededFuture((Object)Boolean.FALSE);
    }
}

