/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver;

import oracle.nosql.driver.util.CheckNull;
import oracle.nosql.driver.values.FieldValue;

public class FieldRange {
    private final String fieldPath;
    private FieldValue start;
    private boolean startInclusive;
    private FieldValue end;
    private boolean endInclusive;

    public FieldRange(String fieldPath) {
        CheckNull.requireNonNull(fieldPath, "FieldRange: fieldPath must be non-null");
        this.fieldPath = fieldPath;
    }

    public FieldValue getStart() {
        return this.start;
    }

    public boolean getStartInclusive() {
        return this.startInclusive;
    }

    public FieldValue getEnd() {
        return this.end;
    }

    public boolean getEndInclusive() {
        return this.endInclusive;
    }

    public String getFieldPath() {
        return this.fieldPath;
    }

    public FieldRange setStart(FieldValue value, boolean isInclusive) {
        CheckNull.requireNonNull(value, "FieldRange.setStart: value must be non-null");
        this.start = value;
        this.startInclusive = isInclusive;
        return this;
    }

    public FieldRange setEnd(FieldValue value, boolean isInclusive) {
        CheckNull.requireNonNull(value, "FieldRange.setEnd: value must be non-null");
        this.end = value;
        this.endInclusive = isInclusive;
        return this;
    }

    public void validate() {
        FieldValue.Type endType;
        FieldValue.Type startType = this.start == null ? null : this.start.getType();
        FieldValue.Type type = endType = this.end == null ? null : this.end.getType();
        if (startType == null && endType == null) {
            throw new IllegalArgumentException("FieldRange: must specify a start or end value");
        }
        if (startType != null && endType != null && endType != startType) {
            throw new IllegalArgumentException("FieldRange: Mismatch of start and end types. Start type is " + (Object)((Object)startType) + ", end type is " + (Object)((Object)endType));
        }
        if (endType != null && startType != null && endType != startType) {
            throw new IllegalArgumentException("FieldRange: Mismatch of start and end types. Start type is " + (Object)((Object)startType) + ", end type is " + (Object)((Object)endType));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(" \"Path\" : ").append(this.fieldPath);
        sb.append(", \"Start\" : ").append(this.start != null ? this.start : "null");
        sb.append(", \"End\" : ").append(this.end != null ? this.end : "null");
        sb.append(", \"StartInclusive\" : ").append(this.startInclusive);
        sb.append(", \"EndInclusive\" : ").append(this.endInclusive);
        sb.append(" }");
        return sb.toString();
    }
}

