/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.query;

import java.io.IOException;
import oracle.nosql.driver.query.PlanIter;
import oracle.nosql.driver.query.PlanIterState;
import oracle.nosql.driver.query.QueryFormatter;
import oracle.nosql.driver.query.RuntimeControlBlock;
import oracle.nosql.driver.util.ByteInputStream;
import oracle.nosql.driver.util.SerializationUtil;

public class VarRefIter
extends PlanIter {
    private final String theName;

    VarRefIter(ByteInputStream in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theName = SerializationUtil.readString(in);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.VAR_REF;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new PlanIterState());
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state.isDone()) {
            if (rcb.getTraceLevel() >= 4) {
                rcb.trace("No Value for variable " + this.theName + " in register " + this.theResultReg);
            }
            return false;
        }
        if (rcb.getTraceLevel() >= 4) {
            rcb.trace("Value for variable " + this.theName + " in register " + this.theResultReg + ":\n" + rcb.getRegVal(this.theResultReg));
        }
        state.done();
        return true;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        state.close();
    }

    @Override
    protected void display(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        this.displayContent(sb, formatter);
        this.displayRegs(sb);
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        sb.append("VAR_REF(");
        sb.append(this.theName);
        sb.append(")");
    }
}

