/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import oracle.nosql.driver.ops.Request;
import oracle.nosql.driver.ops.serde.Serializer;
import oracle.nosql.driver.ops.serde.SerializerFactory;
import oracle.nosql.driver.values.TimestampValue;

public class TableUsageRequest
extends Request {
    private long startTime;
    private long endTime;
    private int limit;

    public TableUsageRequest setCompartment(String compartment) {
        super.setCompartmentInternal(compartment);
        return this;
    }

    public TableUsageRequest setTableName(String tableName) {
        super.setTableNameInternal(tableName);
        return this;
    }

    public TableUsageRequest setStartTime(long startTime) {
        if (startTime < 0L) {
            throw new IllegalArgumentException("startTime must be >= 0");
        }
        this.startTime = startTime;
        return this;
    }

    public TableUsageRequest setStartTime(String startTime) {
        this.startTime = new TimestampValue(startTime).getLong();
        return this;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getStartTimeString() {
        if (this.startTime == 0L) {
            return null;
        }
        return new TimestampValue(this.startTime).getString();
    }

    public TableUsageRequest setEndTime(long endTime) {
        if (endTime < 0L) {
            throw new IllegalArgumentException("endTime must be >= 0");
        }
        this.endTime = endTime;
        return this;
    }

    public TableUsageRequest setEndTime(String endTime) {
        this.endTime = new TimestampValue(endTime).getLong();
        return this;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public String getEndTimeString() {
        if (this.endTime == 0L) {
            return null;
        }
        return new TimestampValue(this.endTime).getString();
    }

    public TableUsageRequest setLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("limit must be >= 0");
        }
        this.limit = limit;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public TableUsageRequest setTimeout(int timeoutMs) {
        super.setTimeoutInternal(timeoutMs);
        return this;
    }

    @Override
    public void validate() {
        if (this.tableName == null) {
            throw new IllegalArgumentException("TableUsageRequest requires a table name");
        }
        if (this.startTime > 0L && this.endTime > 0L && this.endTime < this.startTime) {
            throw new IllegalArgumentException("TableUsageRequest: the endTime must be greater than startTime");
        }
    }

    @Override
    public Serializer createSerializer(SerializerFactory factory) {
        return factory.createGetTableUsageSerializer();
    }

    @Override
    public Serializer createDeserializer(SerializerFactory factory) {
        return factory.createGetTableUsageDeserializer();
    }

    @Override
    public boolean shouldRetry() {
        return false;
    }
}

