/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import java.util.HashMap;
import java.util.Map;

public class RetryStats {
    private int retries = 0;
    private int delayMs = 0;
    private Map<Class<? extends Throwable>, Integer> exceptionMap = new HashMap<Class<? extends Throwable>, Integer>();

    RetryStats() {
    }

    public void addException(Class<? extends Throwable> e) {
        int i = this.getNumExceptions(e) + 1;
        this.exceptionMap.put(e, i);
    }

    public void addDelayMs(int d) {
        this.delayMs += d;
    }

    public void incrementRetries() {
        ++this.retries;
    }

    public int getNumExceptions(Class<? extends Throwable> e) {
        Integer i = this.exceptionMap.get(e);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public int getDelayMs() {
        return this.delayMs;
    }

    public int getRetries() {
        return this.retries;
    }

    public void clear() {
        this.delayMs = 0;
        this.retries = 0;
        this.exceptionMap.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("retries=").append(this.retries).append(" delayMs=").append(this.delayMs).append(" exceptionMap=").append(this.exceptionMap);
        return sb.toString();
    }
}

