/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.iam;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.nosql.driver.Region;
import oracle.nosql.driver.httpclient.HttpClient;
import oracle.nosql.driver.iam.AuthenticationProfileProvider;
import oracle.nosql.driver.iam.CertificateSupplier;
import oracle.nosql.driver.iam.SecurityTokenSupplier;
import oracle.nosql.driver.iam.SessionKeyPairSupplier;
import oracle.nosql.driver.iam.Utils;
import oracle.nosql.driver.util.HttpRequestUtil;

class InstancePrincipalsProvider
implements AuthenticationProfileProvider,
Region.RegionProvider {
    protected final SecurityTokenSupplier tokenSupplier;
    protected final SessionKeyPairSupplier.DefaultSessionKeySupplier sessionKeySupplier;
    private final Region region;

    public InstancePrincipalsProvider(SecurityTokenSupplier tokenSupplier, SessionKeyPairSupplier keyPairSupplier, Region region) {
        this.tokenSupplier = tokenSupplier;
        this.sessionKeySupplier = new SessionKeyPairSupplier.DefaultSessionKeySupplier(keyPairSupplier);
        this.region = region;
    }

    @Override
    public String getKeyId() {
        return "ST$" + this.tokenSupplier.getSecurityToken();
    }

    @Override
    public InputStream getPrivateKey() {
        return new ByteArrayInputStream(this.sessionKeySupplier.getPrivateKeyBytes());
    }

    @Override
    public char[] getPassphraseCharacters() {
        return null;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    public static InstancePrincipalsProviderBuilder builder() {
        return new InstancePrincipalsProviderBuilder();
    }

    public static class InstancePrincipalsProviderBuilder {
        private static final JsonFactory factory = new JsonFactory();
        private static final String METADATA_SERVICE_BASE_URL = "http://169.254.169.254/opc/v2/";
        private static final String FALLBACK_METADATA_SERVICE_URL = "http://169.254.169.254/opc/v1/";
        private static final String AUTHORIZATION_HEADER_VALUE = "Bearer Oracle";
        private static final String METADATA_SERVICE_HOST = "169.254.169.254";
        private static final int DEFAULT_TIMEOUT_MS = 120000;
        private static final String DEFAULT_PURPOSE = "DEFAULT";
        private String baseMetadataURL = "http://169.254.169.254/opc/v2/";
        private String federationEndpoint;
        private CertificateSupplier leafCertificateSupplier;
        private Set<CertificateSupplier> intermediateCertificateSuppliers;
        private SessionKeyPairSupplier sessSupplier = new SessionKeyPairSupplier.JDKKeyPairSupplier();
        private String tenantId;
        private String purpose = "DEFAULT";
        private int timeout = 120000;
        private Region region;
        private Logger logger;

        public String getBaseMetadataURL() {
            return this.baseMetadataURL;
        }

        public String getFederationEndpoint() {
            return this.federationEndpoint;
        }

        public InstancePrincipalsProviderBuilder setFederationEndpoint(String federationEndpoint) {
            this.federationEndpoint = federationEndpoint;
            return this;
        }

        public CertificateSupplier getLeafCertificateSupplier() {
            return this.leafCertificateSupplier;
        }

        public InstancePrincipalsProviderBuilder setLeafCertificateSupplier(CertificateSupplier supplier) {
            this.leafCertificateSupplier = supplier;
            return this;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public InstancePrincipalsProviderBuilder setTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public String getPurpose() {
            return this.purpose;
        }

        public InstancePrincipalsProviderBuilder setPurpose(String purpose) {
            this.purpose = purpose;
            return this;
        }

        public SessionKeyPairSupplier getSesssionKeyPairSupplier() {
            return this.sessSupplier;
        }

        public InstancePrincipalsProviderBuilder setSessionKeyPairSupplier(SessionKeyPairSupplier sessSupplier) {
            this.sessSupplier = sessSupplier;
            return this;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public InstancePrincipalsProviderBuilder setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Logger getLogger() {
            return this.logger;
        }

        public InstancePrincipalsProviderBuilder setLogger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Set<CertificateSupplier> getIntermediateCertificateSuppliers() {
            return this.intermediateCertificateSuppliers;
        }

        public InstancePrincipalsProviderBuilder setIntermediateCertificateSuppliers(Set<CertificateSupplier> suppliers) {
            this.intermediateCertificateSuppliers = suppliers;
            return this;
        }

        public Region getRegion() {
            return this.region;
        }

        public InstancePrincipalsProviderBuilder setRegion(Region r) {
            this.region = r;
            return this;
        }

        public InstancePrincipalsProvider build() {
            if (this.logger == null) {
                this.logger = Logger.getLogger(this.getClass().getName());
                this.logger.setLevel(Level.WARNING);
            }
            this.autoDetectEndpointUsingMetadataUrl();
            this.autoDetectCertificatesUsingMetadataUrl();
            SecurityTokenSupplier tokenSupplier = new SecurityTokenSupplier(this.federationEndpoint, this.tenantId, this.leafCertificateSupplier, this.intermediateCertificateSuppliers, this.sessSupplier, this.purpose, this.timeout, this.logger);
            return new InstancePrincipalsProvider(tokenSupplier, this.sessSupplier, this.region);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void autoDetectEndpointUsingMetadataUrl() {
            if (this.federationEndpoint != null) {
                return;
            }
            String instanceMDURL = this.getInstanceMetadaURL();
            Utils.logTrace(this.logger, "Detecting IAM endpoint using " + instanceMDURL);
            HttpClient client = null;
            try {
                client = new HttpClient(METADATA_SERVICE_HOST, 80, 0, 0, 0, null, "InstanceMDClient", this.logger);
                HttpRequestUtil.HttpResponse response = HttpRequestUtil.doGetRequest(client, instanceMDURL, this.headers(METADATA_SERVICE_HOST), this.timeout, this.logger);
                int status = response.getStatusCode();
                if (status == 404) {
                    Utils.logTrace(this.logger, "Falling back to v1 metadata URL, resource not found from v2");
                    this.baseMetadataURL = FALLBACK_METADATA_SERVICE_URL;
                    instanceMDURL = this.getInstanceMetadaURL();
                    response = HttpRequestUtil.doGetRequest(client, instanceMDURL, this.headers(METADATA_SERVICE_HOST), this.timeout, this.logger);
                    if (response.getStatusCode() != 200) {
                        throw new IllegalStateException(String.format("Unable to get federation URL frominstance metadata http://169.254.169.254/opc/v2/ or fallback to http://169.254.169.254/opc/v1/, status code: %d, output: %s", response.getOutput()));
                    }
                } else if (status != 200) {
                    throw new IllegalStateException(String.format("Unable to get federation URL frominstance metadata http://169.254.169.254/opc/v2/, status code: %d, output: %s", response.getStatusCode(), response.getOutput()));
                }
                Utils.logTrace(this.logger, "Instance metadata " + response.getOutput());
                String insRegion = this.findRegion(response.getOutput());
                Utils.logTrace(this.logger, "Instance region " + insRegion);
                this.federationEndpoint = Utils.getIAMURL(insRegion);
                if (this.federationEndpoint == null) {
                    throw new IllegalStateException("Invalid IAM URI, unknown region " + this.region);
                }
            }
            finally {
                if (client != null) {
                    client.shutdown();
                }
            }
        }

        private String getInstanceMetadaURL() {
            return this.getBaseMetadataURL() + "instance/";
        }

        private HttpHeaders headers(String host) {
            return new DefaultHttpHeaders().add((CharSequence)HttpHeaderNames.HOST, (Object)host).set("Content-Type", (Object)"application/json; charset=UTF-8").set("Authorization", (Object)AUTHORIZATION_HEADER_VALUE);
        }

        private String findRegion(String response) {
            try {
                JsonParser parser = factory.createParser(response);
                if (parser.getCurrentToken() == null) {
                    parser.nextToken();
                }
                while (parser.getCurrentToken() != null) {
                    String field = Utils.findField(response, parser, "region");
                    if (field == null) continue;
                    parser.nextToken();
                    return parser.getText();
                }
                throw new IllegalStateException("Unable to find region in instance metadata " + response);
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Error parsing instance metadata in response " + response + " " + ioe.getMessage());
            }
        }

        private void autoDetectCertificatesUsingMetadataUrl() {
            try {
                if (this.leafCertificateSupplier == null) {
                    this.leafCertificateSupplier = new CertificateSupplier.DefaultCertificateSupplier(this.getURLDetails(this.getBaseMetadataURL() + "identity/cert.pem"), this.getURLDetails(this.getBaseMetadataURL() + "identity/key.pem"), null);
                }
                if (this.tenantId == null) {
                    this.tenantId = Utils.getTenantId(this.leafCertificateSupplier.getCertificateAndKeyPair().getCertificate());
                }
                if (this.intermediateCertificateSuppliers == null) {
                    this.intermediateCertificateSuppliers = new HashSet<CertificateSupplier>();
                    this.intermediateCertificateSuppliers.add(new CertificateSupplier.DefaultCertificateSupplier(this.getURLDetails(this.getBaseMetadataURL() + "identity/intermediate.pem"), null, null));
                }
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException("The instance metadata service url is invalid.", ex);
            }
        }

        private CertificateSupplier.URLResourceDetails getURLDetails(String url) throws MalformedURLException {
            return new CertificateSupplier.URLResourceDetails(new URL(url)).addHeader("Authorization", AUTHORIZATION_HEADER_VALUE);
        }
    }
}

